/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.layout;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class GridBagLayoutContainer
extends GridBagLayout {
    private static final long serialVersionUID = 1L;
    private Insets insets;
    private Component owner;

    public GridBagLayoutContainer(Component owner) {
        this(5, 5, 5, 5, owner);
    }

    public GridBagLayoutContainer(int inseta, int insetb, int insetc, int insetd, Component owner) {
        this.insets = new Insets(inseta, insetb, insetc, insetd);
        this.owner = owner;
        if (this.owner instanceof JFrame) {
            ((JFrame)this.owner).getContentPane().setLayout(this);
        } else if (this.owner instanceof JDialog) {
            ((JDialog)this.owner).getContentPane().setLayout(this);
        } else if (this.owner instanceof JComponent) {
            ((JComponent)this.owner).setLayout(this);
        }
    }

    public GridBagConstraints getGBC(int x, int y) {
        return this.getGBC(x, y, 1, 1);
    }

    public GridBagConstraints getGBC(int x, int y, int w, int h) {
        return this.getGBC(x, y, w, h, 0.0, 0.0);
    }

    public GridBagConstraints getGBC(int x, int y, int w, int h, double weightx, double weighty) {
        return this.getGBC(x, y, w, h, weightx, weighty, 1);
    }

    public GridBagConstraints getGBC(int x, int y, int w, int h, double weightx, double weighty, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = fill;
        gbc.insets = this.insets;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        return gbc;
    }

    public void add(Component c, int x, int y) {
        if (c == null) {
            return;
        }
        this.add(c, this.getGBC(x, y));
    }

    public void add(Component c, int x, int y, int w, int h) {
        if (c == null) {
            return;
        }
        this.add(c, this.getGBC(x, y, w, h));
    }

    public void add(Component c, int x, int y, int w, int h, double weightx, double weighty) {
        if (c == null) {
            return;
        }
        this.add(c, this.getGBC(x, y, w, h, weightx, weighty));
    }

    public void add(Component c, GridBagConstraints gbc) {
        if (c == null) {
            return;
        }
        if (gbc == null) {
            return;
        }
        if (this.owner == null) {
            return;
        }
        this.setConstraints(c, gbc);
        if (this.owner instanceof JFrame) {
            ((JFrame)this.owner).getContentPane().add(c);
        } else if (this.owner instanceof JDialog) {
            ((JDialog)this.owner).getContentPane().add(c);
        } else if (this.owner instanceof JComponent) {
            ((JComponent)this.owner).add(c);
        }
    }
}

