/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HTTPUtil {
    private static final String[] URL_SCHEMES = new String[]{"http", "https"};
    private static final Pattern LEFT_TRIM_PATTERN = Pattern.compile("^[\\s]+");
    private static final Pattern RIGHT_TRIM_PATTERN = Pattern.compile("[\\s]+$");
    private static Logger logger = LoggerFactory.getLogger(HTTPUtil.class);

    private HTTPUtil() {
    }

    public static boolean isURL(String url) {
        UrlValidator urlValidator = new UrlValidator(URL_SCHEMES, 10L);
        return urlValidator.isValid(url);
    }

    public static String trimURL(String url) {
        if (!url.isEmpty() && HTTPUtil.isURL(url)) {
            url = LEFT_TRIM_PATTERN.matcher(url).replaceAll("");
            url = RIGHT_TRIM_PATTERN.matcher(url).replaceAll("");
        }
        return url;
    }

    public static String encodeURL(String url, boolean checkForPercentCharacter) {
        String encodedURL = url;
        if (checkForPercentCharacter && url.contains("%")) {
            return encodedURL;
        }
        try {
            URL parsedURL = new URL(url);
            URI uri = new URI(parsedURL.getProtocol(), parsedURL.getUserInfo(), parsedURL.getHost(), parsedURL.getPort(), parsedURL.getPath(), parsedURL.getQuery(), parsedURL.getRef());
            encodedURL = uri.toASCIIString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            logger.error("Could not encode URL, because it is malformed: {}", (Object)url, (Object)e);
        }
        logger.debug("URL: {}, EncodedURL: {}", (Object)url, (Object)encodedURL);
        return encodedURL;
    }

    public static String encodeURL(String url) {
        return HTTPUtil.encodeURL(url, true);
    }

    public static String decodeURL(String url) {
        String decodedURL = url;
        try {
            URL parsedURL = new URL(url);
            URI uri = parsedURL.toURI();
            StringBuilder sb = new StringBuilder();
            String scheme = uri.getScheme();
            if (scheme != null) {
                sb.append(scheme);
                sb.append(':');
            }
            if (uri.isOpaque()) {
                sb.append(uri.getSchemeSpecificPart());
            } else {
                String query;
                String host = uri.getHost();
                String authority = uri.getAuthority();
                if (host != null) {
                    int port;
                    boolean bracketsNeeded;
                    sb.append("//");
                    String userInfo = uri.getUserInfo();
                    if (userInfo != null) {
                        sb.append(userInfo);
                        sb.append('@');
                    }
                    boolean bl = bracketsNeeded = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
                    if (bracketsNeeded) {
                        sb.append('[');
                    }
                    sb.append(host);
                    if (bracketsNeeded) {
                        sb.append(']');
                    }
                    if ((port = uri.getPort()) != -1) {
                        sb.append(':');
                        sb.append(port);
                    }
                } else if (authority != null) {
                    sb.append("//");
                    sb.append(authority);
                }
                String path = uri.getPath();
                if (path != null) {
                    sb.append(path);
                }
                if ((query = uri.getQuery()) != null) {
                    sb.append('?');
                    sb.append(query);
                }
            }
            String fragment = uri.getFragment();
            if (fragment != null) {
                sb.append('#');
                sb.append(fragment);
            }
            decodedURL = sb.toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            logger.error("Could not decode URL, because it is malformed: {}", (Object)url, (Object)e);
        }
        logger.debug("URL: {}, DecodedURL: {}", (Object)url, (Object)decodedURL);
        return decodedURL;
    }

    public static String getDomainFromURL(String url) {
        try {
            URL parsedURL = new URL(url);
            return parsedURL.getHost();
        }
        catch (MalformedURLException e) {
            logger.debug("Could not get domain from URL: {}", (Object)url, (Object)e);
            return "";
        }
    }

    public static String[] getDomainAndPathFromURL(String url) {
        int posPath;
        String schemeSearch = "://";
        int posDomain = url.indexOf(schemeSearch);
        if (posDomain > -1 && (posPath = url.indexOf(47, posDomain + schemeSearch.length())) > -1) {
            return new String[]{url.substring(0, posPath + 1), url.substring(posPath + 1)};
        }
        return null;
    }

    public static String getTLDName(String domain) {
        int posSubDomainDot;
        int posTldDot = domain.lastIndexOf(46);
        if (posTldDot > 0 && (posSubDomainDot = domain.lastIndexOf(46, posTldDot - 1)) > -1) {
            return domain.substring(posSubDomainDot + 1);
        }
        return domain;
    }

    public static String getFilenameFromURL(String url, String defaultValue) {
        try {
            URL parsedURL = new URL(url);
            String path = parsedURL.getPath();
            int pos = path.lastIndexOf("/");
            if (pos > -1) {
                return path.substring(pos + 1);
            }
            return defaultValue;
        }
        catch (MalformedURLException e) {
            logger.debug("Could not get filename from URL: {}", (Object)url, (Object)e);
            return defaultValue;
        }
    }

    public static String getBaseURL(String url) {
        int posPath = url.lastIndexOf("/");
        if (posPath > 0) {
            return url.substring(0, posPath + 1);
        }
        return url;
    }

    public static String convertURLFromRelativeToAbsolute(String referrer, String urlToConvert) {
        String baseURL = HTTPUtil.getBaseURL(referrer);
        if (!baseURL.endsWith("/")) {
            return baseURL + "/" + urlToConvert;
        }
        return baseURL + urlToConvert;
    }
}

