/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat;

import ch.supertomcat.supertomcatutils.http.cookies.BrowserCookie;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookie;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookieRoot;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public final class OperaCookies {
    private OperaCookies() {
    }

    public static List<BrowserCookie> getCookiesFromOpera(String domain, String[] hosts, String[] paths, String cookieFile) {
        if (cookieFile.isEmpty()) {
            return new ArrayList<BrowserCookie>();
        }
        OperaCookieRoot operaCookieRoot = new OperaCookieRoot(cookieFile);
        if (!operaCookieRoot.read()) {
            return new ArrayList<BrowserCookie>();
        }
        List<OperaCookie> cookies = operaCookieRoot.getAllCookies();
        ArrayList<BrowserCookie> browserCookies = new ArrayList<BrowserCookie>();
        for (OperaCookie currentCookie : cookies) {
            boolean matchedPath;
            boolean matchedDomain = currentCookie.getDomain().equals(domain);
            if (!matchedDomain) {
                for (String host : hosts) {
                    matchedDomain = currentCookie.getDomain().equals(host.substring(1));
                    if (matchedDomain) break;
                }
            }
            if (!(matchedPath = currentCookie.getPath().isEmpty())) {
                for (String path : paths) {
                    boolean bl = matchedPath = currentCookie.getPath().equals(path) || currentCookie.getPath().equals(path + "/");
                    if (matchedPath) break;
                }
            }
            if (!matchedDomain || !matchedPath) continue;
            BrowserCookie browserCookie = new BrowserCookie(currentCookie.getName(), currentCookie.getValue());
            browserCookie.setDomain(currentCookie.getDomain());
            browserCookie.setPath(currentCookie.getPath());
            browserCookie.setSecure(currentCookie.isSecure());
            browserCookie.setExpiryDate(Instant.ofEpochSecond(currentCookie.getExpires()));
            browserCookies.add(browserCookie);
        }
        return browserCookies;
    }

    public static String getCookieFileForOpera(boolean checkExist) {
        String os = System.getProperty("os.name").toLowerCase();
        Object operaCookieFile = "";
        if (os.contains("windows")) {
            operaCookieFile = System.getenv("APPDATA");
            if (!OperaCookies.checkFileExists((String)(operaCookieFile = (String)operaCookieFile + "/Opera/Opera/profile/cookies4.dat"))) {
                operaCookieFile = System.getenv("APPDATA");
                operaCookieFile = (String)operaCookieFile + "/Opera/Opera/cookies4.dat";
            }
        } else if (os.contains("mac")) {
            operaCookieFile = System.getProperty("user.home");
            operaCookieFile = (String)operaCookieFile + "Library/Preferences/Opera Preferences/cookies4.dat";
        } else {
            operaCookieFile = System.getProperty("user.home");
            operaCookieFile = (String)operaCookieFile + "/.opera/cookies4.dat";
        }
        if (checkExist && !OperaCookies.checkFileExists((String)operaCookieFile)) {
            return "";
        }
        return operaCookieFile;
    }

    private static boolean checkFileExists(String strFile) {
        return new File(strFile).exists();
    }
}

