/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers;

import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookie;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaCookieHeader;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaDomain;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.OperaPath;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.values.OperaByteValue;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.values.OperaIntegerValue;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.values.OperaLongValue;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.values.OperaShortValue;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.values.OperaStringValue;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.containers.values.OperaTimeValue;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaCookieInputStream
extends DataInputStream {
    public static final int O_MSB_VALUE_1 = 128;
    public static final int O_MSB_VALUE_2 = 32768;
    public static final int O_MSB_VALUE_3 = 0x800000;
    public static final long O_MSB_VALUE_L = 0x800000L;
    public static final int O_MSB_VALUE_4 = Integer.MIN_VALUE;
    public static final int O_NULL_BYTE = 0;
    public static final int O_DOMAIN_START = 1;
    public static final int O_DOMAIN_END_1 = 132;
    public static final int O_DOMAIN_END_2 = 32772;
    public static final int O_DOMAIN_END_3 = 0x800004;
    public static final long O_DOMAIN_END_L = 0x800004L;
    public static final int O_DOMAIN_END_4 = -2147483644;
    public static final int O_DOMAIN_NAME = 30;
    public static final int O_DOMAIN_ACCEPT = 31;
    public static final int O_DOMAIN_PATH_NOT_MATCHING = 33;
    public static final int O_DOMAIN_THIRD_PARTY_COOKIE = 37;
    public static final int O_PATH_START = 2;
    public static final int O_PATH_NAME = 29;
    public static final int O_PATH_END_1 = 133;
    public static final int O_PATH_END_2 = 32773;
    public static final int O_PATH_END_3 = 0x800005;
    public static final int O_PATH_END_4 = -2147483643;
    public static final int O_COOKIE_START = 3;
    public static final int O_COOKIE_NAME = 16;
    public static final int O_COOKIE_VALUE = 17;
    public static final int O_COOKIE_EXPIRES = 18;
    public static final int O_COOKIE_LAST_USED = 19;
    public static final int O_COOKIE_COMMENT = 20;
    public static final int O_COOKIE_COMMENT_URL = 21;
    public static final int O_COOKIE_RECEIVED_DOMAIN = 22;
    public static final int O_COOKIE_RECEIVED_PATH = 23;
    public static final int O_COOKIE_PORTLIST = 24;
    public static final int O_COOKIE_SECURE_1 = 153;
    public static final int O_COOKIE_SECURE_2 = 32793;
    public static final int O_COOKIE_SECURE_3 = 8388633;
    public static final int O_COOKIE_SECURE_4 = -2147483623;
    public static final int O_COOKIE_VERSION = 26;
    public static final int O_COOKIE_SERVER_ONLY_1 = 155;
    public static final int O_COOKIE_SERVER_ONLY_2 = 32795;
    public static final int O_COOKIE_SERVER_ONLY_3 = 8388635;
    public static final int O_COOKIE_SERVER_ONLY_4 = -2147483621;
    public static final int O_COOKIE_PROTECTED_1 = 156;
    public static final int O_COOKIE_PROTECTED_2 = 32796;
    public static final int O_COOKIE_PROTECTED_3 = 8388636;
    public static final int O_COOKIE_PROTECTED_4 = -2147483620;
    public static final int O_COOKIE_PATH_PREFIX_1 = 160;
    public static final int O_COOKIE_PATH_PREFIX_2 = 32800;
    public static final int O_COOKIE_PATH_PREFIX_3 = 0x800020;
    public static final int O_COOKIE_PATH_PREFIX_4 = -2147483616;
    public static final int O_COOKIE_PASSWORD_1 = 162;
    public static final int O_COOKIE_PASSWORD_2 = 32802;
    public static final int O_COOKIE_PASSWORD_3 = 0x800022;
    public static final int O_COOKIE_PASSWORD_4 = -2147483614;
    public static final int O_COOKIE_AUTHENTICATE_1 = 163;
    public static final int O_COOKIE_AUTHENTICATE_2 = 32803;
    public static final int O_COOKIE_AUTHENTICATE_3 = 8388643;
    public static final int O_COOKIE_AUTHENTICATE_4 = -2147483613;
    public static final int O_COOKIE_THIRD_PARTY_1 = 164;
    public static final int O_COOKIE_THIRD_PARTY_2 = 32804;
    public static final int O_COOKIE_THIRD_PARTY_3 = 8388644;
    public static final int O_COOKIE_THIRD_PARTY_4 = -2147483612;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public OperaCookieInputStream(InputStream in) {
        super(in);
    }

    public long read3ByteUnsignedInt() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        int signedInt = (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
        return Integer.toUnsignedLong(signedInt);
    }

    public int read3ByteUnsignedIntAsInt() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        int signedInt = this.readInt();
        return Integer.toUnsignedLong(signedInt);
    }

    public int readUnsignedIntAsInt() throws IOException {
        return this.readInt();
    }

    public long readStringValue(OperaStringValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        StringBuilder sb = new StringBuilder();
        for (long i = 0L; i < payloadSize; ++i) {
            sb.append((char)this.readByte());
        }
        value.setValue(sb.toString());
        return (long)recordSize + payloadSize;
    }

    public long readTimeValue(OperaTimeValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize == 4L) {
            value.setValue(this.readUnsignedInt());
        } else if (payloadSize == 8L) {
            this.readUnsignedInt();
            value.setValue(this.readUnsignedInt());
        } else {
            throw new IOException("Unexpected Payload Size for time_t value: " + payloadSize);
        }
        return (long)recordSize + payloadSize;
    }

    public long readInt8Value(OperaByteValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize != 1L) {
            throw new IOException("Unexpected Payload Size for int8 value: " + payloadSize);
        }
        value.setValue(this.readByte());
        return (long)recordSize + payloadSize;
    }

    public long readInt16Value(OperaShortValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize != 2L) {
            throw new IOException("Unexpected Payload Size for int16 value: " + payloadSize);
        }
        value.setValue(this.readShort());
        return (long)recordSize + payloadSize;
    }

    public long readInt32Value(OperaIntegerValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize != 4L) {
            throw new IOException("Unexpected Payload Size for int32 value: " + payloadSize);
        }
        value.setValue(this.readInt());
        return (long)recordSize + payloadSize;
    }

    public long readUInt8Value(OperaIntegerValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize != 1L) {
            throw new IOException("Unexpected Payload Size for uint8 value: " + payloadSize);
        }
        value.setValue(this.readUnsignedByte());
        return (long)recordSize + payloadSize;
    }

    public long readUInt16Value(OperaIntegerValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize != 2L) {
            throw new IOException("Unexpected Payload Size for uint16 value: " + payloadSize);
        }
        value.setValue(this.readUnsignedShort());
        return (long)recordSize + payloadSize;
    }

    public long readUInt32Value(OperaLongValue value, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        if (payloadSize != 4L) {
            throw new IOException("Unexpected Payload Size for uint32 value: " + payloadSize);
        }
        value.setValue(this.readUnsignedInt());
        return (long)recordSize + payloadSize;
    }

    public int read(OperaCookieHeader och) throws IOException {
        int read = 0;
        read += this.readFileVersion(och);
        read += this.readAppVersion(och);
        read += this.readTagSize(och);
        return read += this.readRecordSize(och);
    }

    private int readFileVersion(OperaCookieHeader och) throws IOException {
        long fileVersion = this.readUnsignedInt();
        och.setFileVersion(fileVersion);
        return 4;
    }

    private int readAppVersion(OperaCookieHeader och) throws IOException {
        long appVersion = this.readUnsignedInt();
        och.setAppVersion(appVersion);
        return 4;
    }

    private int readTagSize(OperaCookieHeader och) throws IOException {
        int tagSize = this.readUnsignedShort();
        och.setTagSize(tagSize);
        return 2;
    }

    private int readRecordSize(OperaCookieHeader och) throws IOException {
        int recordSize = this.readUnsignedShort();
        och.setRecordSize(recordSize);
        return 2;
    }

    public int readTagID(int tagSize) throws IOException {
        try {
            switch (tagSize) {
                case 1: {
                    return this.readUnsignedByte();
                }
                case 2: {
                    return this.readUnsignedShort();
                }
                case 3: {
                    return this.read3ByteUnsignedIntAsInt();
                }
                case 4: {
                    return this.readUnsignedIntAsInt();
                }
            }
            throw new IOException("Could not read tag ID, not supported tag size: " + tagSize);
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public long readPayloadSize(int recordSize) throws IOException {
        switch (recordSize) {
            case 1: {
                return this.readUnsignedByte();
            }
            case 2: {
                return this.readUnsignedShort();
            }
            case 4: {
                return this.readUnsignedInt();
            }
        }
        throw new IOException("Could not read payload size, not supported record size: " + recordSize);
    }

    public List<OperaDomain> readDomainComponents(int tagSize, int recordSize) throws IOException {
        int tagID;
        ArrayList<OperaDomain> countryTopLevelDomains = new ArrayList<OperaDomain>();
        ArrayDeque<OperaDomain> domainStack = new ArrayDeque<OperaDomain>();
        ArrayDeque<OperaPath> pathStack = new ArrayDeque<OperaPath>();
        block7: while ((tagID = this.readTagID(tagSize)) != -1) {
            switch (tagID) {
                case 1: {
                    OperaDomain parentDomain;
                    OperaDomain currentDomain = new OperaDomain();
                    if (domainStack.isEmpty()) {
                        parentDomain = null;
                        countryTopLevelDomains.add(currentDomain);
                    } else {
                        parentDomain = (OperaDomain)domainStack.peek();
                        parentDomain.addSubDomain(currentDomain);
                    }
                    this.readDomainRecord(currentDomain, parentDomain, tagSize, recordSize);
                    domainStack.push(currentDomain);
                    continue block7;
                }
                case -2147483644: 
                case 132: 
                case 32772: 
                case 0x800004: {
                    if (domainStack.isEmpty()) {
                        this.logger.error("There are no domains on the stack, even though there should be one");
                    } else {
                        domainStack.pop();
                    }
                    if (!pathStack.isEmpty()) {
                        this.logger.error("There are paths on the stack, which were never closed: {}", (Object)pathStack.size());
                    }
                    pathStack.clear();
                    continue block7;
                }
                case 2: {
                    OperaPath parentPath;
                    OperaPath currentPath = new OperaPath();
                    OperaDomain parentDomainForPath = (OperaDomain)domainStack.peek();
                    if (pathStack.isEmpty()) {
                        parentPath = null;
                        parentDomainForPath.addPath(currentPath);
                    } else {
                        parentPath = (OperaPath)pathStack.peek();
                        parentPath.addSubPath(currentPath);
                    }
                    this.readPathRecord(currentPath, parentPath, tagSize, recordSize);
                    pathStack.push(currentPath);
                    continue block7;
                }
                case -2147483643: 
                case 133: 
                case 32773: 
                case 0x800005: {
                    if (pathStack.isEmpty()) continue block7;
                    pathStack.pop();
                    continue block7;
                }
                case 3: {
                    OperaDomain parentDomainForCookie = (OperaDomain)domainStack.peek();
                    OperaPath parentPathForCookie = null;
                    if (!pathStack.isEmpty()) {
                        parentPathForCookie = (OperaPath)pathStack.peek();
                    }
                    OperaCookie currentCookie = new OperaCookie();
                    currentCookie.setDomain(parentDomainForCookie.getFullyQualifiedName());
                    if (parentPathForCookie != null) {
                        parentPathForCookie.addCookie(currentCookie);
                        currentCookie.setPath(parentPathForCookie.getFullyQualifiedName());
                    } else {
                        parentDomainForCookie.addCookie(currentCookie);
                        currentCookie.setPath("");
                    }
                    this.readCookieRecord(currentCookie, tagSize, recordSize);
                    continue block7;
                }
            }
            this.logger.error("Unexpected Tag ID: {}", (Object)tagID);
        }
        return countryTopLevelDomains;
    }

    public long readDomainRecord(OperaDomain operaDomain, OperaDomain parentDomain, int tagSize, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        long read = 0L;
        block7: while (read < payloadSize) {
            int tagID = this.readTagID(tagSize);
            read += (long)tagSize;
            if (tagID == -1) {
                throw new IOException("Unexpected end of file");
            }
            switch (tagID) {
                case 30: {
                    OperaStringValue strName = new OperaStringValue();
                    read += this.readStringValue(strName, recordSize);
                    String name = (String)strName.getValue();
                    operaDomain.setName(name);
                    if (parentDomain != null) {
                        operaDomain.setFullyQualifiedName(name + "." + parentDomain.getFullyQualifiedName());
                        continue block7;
                    }
                    operaDomain.setFullyQualifiedName(name);
                    continue block7;
                }
                case 31: {
                    OperaByteValue acceptValue = new OperaByteValue();
                    read += this.readInt8Value(acceptValue, recordSize);
                    operaDomain.setAccept((Byte)acceptValue.getValue());
                    continue block7;
                }
                case 33: {
                    OperaByteValue notMatchValue = new OperaByteValue();
                    read += this.readInt8Value(notMatchValue, recordSize);
                    operaDomain.setNotMatch((Byte)notMatchValue.getValue());
                    continue block7;
                }
                case 37: {
                    OperaByteValue thirdPartyValue = new OperaByteValue();
                    read += this.readInt8Value(thirdPartyValue, recordSize);
                    operaDomain.setThirdParty((Byte)thirdPartyValue.getValue());
                    continue block7;
                }
                case 0: {
                    continue block7;
                }
            }
            this.logger.error("Unexpected Tag ID in Domain Record: {}", (Object)tagID);
        }
        if (read != payloadSize) {
            throw new IOException("Read too less or too much bytes. Payload Size: " + payloadSize + ", Read: " + read);
        }
        return read;
    }

    public long readPathRecord(OperaPath operaPath, OperaPath parentPath, int tagSize, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        long read = 0L;
        block4: while (read < payloadSize) {
            int tagID = this.readTagID(tagSize);
            read += (long)tagSize;
            if (tagID == -1) {
                throw new IOException("Unexpected end of file");
            }
            switch (tagID) {
                case 29: {
                    OperaStringValue strName = new OperaStringValue();
                    read += this.readStringValue(strName, recordSize);
                    String name = (String)strName.getValue();
                    operaPath.setName(name);
                    if (parentPath != null) {
                        operaPath.setFullyQualifiedName(parentPath.getFullyQualifiedName() + "/" + name);
                        continue block4;
                    }
                    operaPath.setFullyQualifiedName(name);
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            this.logger.error("Unexpected Tag ID in Path Record: {}", (Object)tagID);
        }
        if (read != payloadSize) {
            throw new IOException("Read too less or too much bytes. Payload Size: " + payloadSize + ", Read: " + read);
        }
        return read;
    }

    public long readCookieRecord(OperaCookie operaCookie, int tagSize, int recordSize) throws IOException {
        long payloadSize = this.readPayloadSize(recordSize);
        long read = 0L;
        block20: while (read < payloadSize) {
            int tagID = this.readTagID(tagSize);
            read += (long)tagSize;
            if (tagID == -1) {
                throw new IOException("Unexpected end of file");
            }
            switch (tagID) {
                case 16: {
                    OperaStringValue strName = new OperaStringValue();
                    read += this.readStringValue(strName, recordSize);
                    operaCookie.setName((String)strName.getValue());
                    continue block20;
                }
                case 17: {
                    OperaStringValue strValue = new OperaStringValue();
                    read += this.readStringValue(strValue, recordSize);
                    operaCookie.setValue((String)strValue.getValue());
                    continue block20;
                }
                case 18: {
                    OperaTimeValue expiresValue = new OperaTimeValue();
                    read += this.readTimeValue(expiresValue, recordSize);
                    operaCookie.setExpires((Long)expiresValue.getValue());
                    continue block20;
                }
                case 19: {
                    OperaTimeValue lastUsedValue = new OperaTimeValue();
                    read += this.readTimeValue(lastUsedValue, recordSize);
                    operaCookie.setLastUsed((Long)lastUsedValue.getValue());
                    continue block20;
                }
                case 20: {
                    OperaStringValue strComment = new OperaStringValue();
                    read += this.readStringValue(strComment, recordSize);
                    operaCookie.setComment((String)strComment.getValue());
                    continue block20;
                }
                case 21: {
                    OperaStringValue strCommentURL = new OperaStringValue();
                    read += this.readStringValue(strCommentURL, recordSize);
                    operaCookie.setCommentURL((String)strCommentURL.getValue());
                    continue block20;
                }
                case 22: {
                    OperaStringValue strReceivedDomain = new OperaStringValue();
                    read += this.readStringValue(strReceivedDomain, recordSize);
                    operaCookie.setRecvDomain((String)strReceivedDomain.getValue());
                    continue block20;
                }
                case 23: {
                    OperaStringValue strReceivedPath = new OperaStringValue();
                    read += this.readStringValue(strReceivedPath, recordSize);
                    operaCookie.setRecvPath((String)strReceivedPath.getValue());
                    continue block20;
                }
                case 24: {
                    OperaStringValue strPortList = new OperaStringValue();
                    read += this.readStringValue(strPortList, recordSize);
                    operaCookie.setPortList((String)strPortList.getValue());
                    continue block20;
                }
                case -2147483623: 
                case 153: 
                case 32793: 
                case 8388633: {
                    operaCookie.setSecure(true);
                    continue block20;
                }
                case 26: {
                    OperaByteValue versionValue = new OperaByteValue();
                    read += this.readInt8Value(versionValue, recordSize);
                    operaCookie.setVersion(((Byte)versionValue.getValue()).byteValue());
                    continue block20;
                }
                case -2147483621: 
                case 155: 
                case 32795: 
                case 8388635: {
                    operaCookie.setServer(true);
                    continue block20;
                }
                case -2147483620: 
                case 156: 
                case 32796: 
                case 8388636: {
                    operaCookie.setDeleteProtected(true);
                    continue block20;
                }
                case -2147483616: 
                case 160: 
                case 32800: 
                case 0x800020: {
                    operaCookie.setPrefixed(true);
                    continue block20;
                }
                case -2147483614: 
                case 162: 
                case 32802: 
                case 0x800022: {
                    operaCookie.setPassword(true);
                    continue block20;
                }
                case -2147483613: 
                case 163: 
                case 32803: 
                case 8388643: {
                    operaCookie.setAuthenticate(true);
                    continue block20;
                }
                case -2147483612: 
                case 164: 
                case 32804: 
                case 8388644: {
                    operaCookie.setThirdParty(true);
                    continue block20;
                }
                case 0: {
                    continue block20;
                }
            }
            this.logger.error("Unexpected Tag ID in Cookie Record: {}", (Object)tagID);
        }
        if (read != payloadSize) {
            throw new IOException("Read too less or too much bytes. Payload Size: " + payloadSize + ", Read: " + read);
        }
        return read;
    }
}

