/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;

public final class PositionUtil {
    private PositionUtil() {
    }

    public static void setPositionMiddleScreen(Window window, Component parent) {
        if (window == null) {
            return;
        }
        GraphicsDevice device = PositionUtil.getScreenDeviceOfComponent(parent);
        if (device != null) {
            Rectangle screenBounds = device.getDefaultConfiguration().getBounds();
            Point screenCenterPoint = PositionUtil.getCenterPoint(screenBounds);
            int screenX = screenBounds.x;
            int screenY = screenBounds.y;
            int screenCenterX = screenCenterPoint.x;
            int screenCenterY = screenCenterPoint.y;
            int screenWidth = screenBounds.width;
            int screenHeight = screenBounds.height;
            int windowWidth = window.getWidth();
            int windowHeight = window.getHeight();
            int targetX = screenCenterX - windowWidth / 2;
            int targetY = screenCenterY - windowHeight / 2;
            if (targetY + windowHeight > screenY + screenHeight) {
                targetY = screenY + screenHeight - windowHeight;
            }
            if (targetY < screenY) {
                targetY = screenY;
            }
            if (targetX + windowWidth > screenX + screenWidth) {
                targetX = screenX + screenWidth - windowWidth;
            }
            if (targetX < screenX) {
                targetX = screenX;
            }
            window.setLocation(targetX, targetY);
        } else {
            window.setLocationRelativeTo(null);
        }
    }

    public static GraphicsDevice getScreenDeviceOfComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        GraphicsConfiguration graphicsConfig = comp.getGraphicsConfiguration();
        if (graphicsConfig != null) {
            return graphicsConfig.getDevice();
        }
        return null;
    }

    private static Rectangle getIntersection(GraphicsDevice device, Rectangle bounds) {
        return device.getDefaultConfiguration().getBounds().intersection(bounds);
    }

    private static long getIntersectionSquared(GraphicsDevice device, Rectangle bounds) {
        Rectangle intersection = PositionUtil.getIntersection(device, bounds);
        return Math.abs((long)intersection.width * (long)intersection.height);
    }

    public static GraphicsDevice getScreenDeviceOfComponent(Rectangle bounds) {
        if (bounds == null) {
            return null;
        }
        Predicate<GraphicsDevice> containsBoundsFilter = device -> device.getDefaultConfiguration().getBounds().intersects(bounds);
        Comparator highestIntersectionComparator = (first, second) -> Long.compare(PositionUtil.getIntersectionSquared(first, bounds), PositionUtil.getIntersectionSquared(second, bounds));
        BinaryOperator biggestIntersectionReduction = (first, second) -> second;
        return Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).filter(containsBoundsFilter).sorted(highestIntersectionComparator).reduce(biggestIntersectionReduction).orElse(null);
    }

    public static Point getCenterPoint(Rectangle bounds) {
        return PositionUtil.getCenterPoint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public static Point getCenterPoint(int x, int y, int width, int height) {
        return new Point(x + width / 2, y + height / 2);
    }

    public static double getWindowScaling(GraphicsDevice device) {
        return device.getDefaultConfiguration().getDefaultTransform().getScaleX();
    }

    public static boolean checkWindowScalingNeeded(double windowScaling) {
        return BigDecimal.valueOf(windowScaling).compareTo(BigDecimal.ONE) > 0;
    }
}

