/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.dialog.about;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.gui.dialog.about.AboutDialogLibrariesPanel;
import ch.supertomcat.supertomcatutils.gui.dialog.about.AboutDialogLicensePanel;
import ch.supertomcat.supertomcatutils.gui.dialog.about.AboutDialogMemoryPanel;
import ch.supertomcat.supertomcatutils.gui.dialog.about.AboutDialogProgramPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JTabbedPane tabPane = new JTabbedPane();
    protected AboutDialogProgramPanel pnlProgram = new AboutDialogProgramPanel();
    protected AboutDialogLicensePanel pnlLicense = new AboutDialogLicensePanel();
    protected AboutDialogLibrariesPanel pnlLibraries = new AboutDialogLibrariesPanel();
    protected AboutDialogMemoryPanel pnlMemory = new AboutDialogMemoryPanel();
    protected JPanel pnlMain = new JPanel(new BorderLayout());
    protected JPanel pnlButtons = new JPanel();

    public AboutDialog(Window owner, String title, Image icon) {
        this.setTitle(title);
        this.setIconImage(icon);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.configureComponents();
        this.fillApplicationInformation();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AboutDialog.this.pnlMemory.cancelUpdateTimer();
            }
        });
        this.addComponents();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected void configureComponents() {
        this.configureTabs();
        this.pnlMain.add((Component)this.tabPane, "Center");
        this.pnlMain.add((Component)this.pnlMemory, "South");
    }

    protected void configureTabs() {
        this.tabPane.addTab("Program", this.pnlProgram);
        this.tabPane.addTab("License", this.pnlLicense);
        this.tabPane.addTab("Libraries", this.pnlLibraries);
    }

    protected void addComponents() {
        this.add((Component)this.pnlMain, "Center");
        this.add((Component)this.pnlButtons, "South");
    }

    protected void fillApplicationInformation() {
        this.fillProgramInformation();
        this.fillApplicationPathsInformation();
        this.fillApplicationLicenseInformation();
    }

    protected void fillProgramInformation() {
        this.pnlProgram.fillProgramInformation(ApplicationProperties.getProperty("ApplicationName"), ApplicationProperties.getProperty("ApplicationVersion"));
    }

    protected void fillApplicationPathsInformation() {
        this.pnlProgram.addProgramFolderInformation("Program Path:", ApplicationProperties.getProperty("ApplicationPath"));
        this.pnlProgram.addProgramFolderInformation("Profile Path:", ApplicationProperties.getProperty("ProfilePath"));
        Path profilePath = Paths.get(ApplicationProperties.getProperty("ProfilePath"), new String[0]);
        this.pnlProgram.addProgramFolderInformation("Logs Path:", ApplicationProperties.getProperty("LogsPath"), profilePath);
    }

    protected void fillApplicationLicenseInformation() {
        String licenseName = ApplicationProperties.getProperty("LicenseName");
        String licenseText = ApplicationProperties.getProperty("LicenseText");
        if (licenseName != null && licenseText != null) {
            this.pnlLicense.fillLicenseInformation(licenseName, licenseText);
        }
    }

    protected void openURL(String url) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                this.logger.error("Could not open URL: {}", (Object)url, (Object)e);
            }
        } else {
            this.logger.error("Could not open URL, because Desktop is not supported: {}", (Object)url);
        }
    }
}

