/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.dialog.about;

import ch.supertomcat.supertomcatutils.gui.FileExplorerUtil;
import ch.supertomcat.supertomcatutils.gui.Icons;
import ch.supertomcat.supertomcatutils.gui.dialog.about.InfoActionType;
import ch.supertomcat.supertomcatutils.gui.layout.SpringUtilities;
import java.awt.FlowLayout;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialogProgramPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JPanel pnlProgramMainInfo = new JPanel();
    protected JPanel pnlProgramDetailInfo = new JPanel(new SpringLayout());
    protected JPanel pnlSystemInfo = new JPanel(new SpringLayout());
    protected JPanel pnlJavaInfo = new JPanel(new SpringLayout());

    public AboutDialogProgramPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.pnlProgramMainInfo.setLayout(new FlowLayout(0));
        SpringUtilities.makeCompactGrid(this.pnlProgramDetailInfo, 0, 0, 0, 0, 5, 5);
        this.pnlSystemInfo.setBorder(BorderFactory.createTitledBorder("System:"));
        this.pnlJavaInfo.setBorder(BorderFactory.createTitledBorder("Java:"));
        this.add(this.pnlProgramMainInfo);
        this.add(this.pnlProgramDetailInfo);
        this.add(this.pnlSystemInfo);
        this.add(this.pnlJavaInfo);
        this.fillSystemInformation();
        this.fillJavaInformation();
    }

    public void fillProgramInformation(String name, String version) {
        JLabel lblNameVersion = new JLabel(name + " (" + version + ")");
        this.pnlProgramMainInfo.add(lblNameVersion);
    }

    public void addProgramFolderInformation(String title, String folder) {
        this.addProgramFolderInformation(title, folder, null);
    }

    public void addProgramFolderInformation(String title, String folderPath, Path referenceFolder) {
        Path folder = Paths.get(folderPath, new String[0]);
        if (referenceFolder != null && folder.equals(referenceFolder)) {
            return;
        }
        this.addInformation(this.pnlProgramDetailInfo, title, folder.toAbsolutePath().toString(), InfoActionType.FOLDER);
        SpringUtilities.makeCompactGrid(this.pnlProgramDetailInfo, this.pnlProgramDetailInfo.getComponentCount() / 3, 3, 0, 0, 5, 5);
    }

    public void addProgramContactInformation(String emailAddress) {
        this.addInformation(this.pnlProgramDetailInfo, "E-Mail:", emailAddress, InfoActionType.EMAIL);
        SpringUtilities.makeCompactGrid(this.pnlProgramDetailInfo, this.pnlProgramDetailInfo.getComponentCount() / 3, 3, 0, 0, 5, 5);
    }

    protected void fillSystemInformation() {
        this.addInformation(this.pnlSystemInfo, "Operating System:", System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        this.addInformation(this.pnlSystemInfo, "Processors:", Integer.toString(Runtime.getRuntime().availableProcessors()));
        SpringUtilities.makeCompactGrid(this.pnlSystemInfo, 2, 3, 0, 0, 5, 5);
    }

    protected void fillJavaInformation() {
        this.addInformation(this.pnlJavaInfo, "Version:", System.getProperty("java.version"));
        this.addInformation(this.pnlJavaInfo, "Vendor:", System.getProperty("java.vendor"));
        this.addInformation(this.pnlJavaInfo, "VM Name:", System.getProperty("java.vm.name"));
        this.addInformation(this.pnlJavaInfo, "Directory:", System.getProperty("java.home"), InfoActionType.FOLDER);
        SpringUtilities.makeCompactGrid(this.pnlJavaInfo, 4, 3, 0, 0, 5, 5);
    }

    protected void addInformation(JPanel pnl, String title, String information) {
        this.addInformation(pnl, title, information, null);
    }

    protected void addInformation(JPanel pnl, String title, String information, InfoActionType infoActionType) {
        pnl.add(new JLabel(title));
        JTextField txt = new JTextField(information);
        txt.setEditable(false);
        pnl.add(txt);
        if (infoActionType != null) {
            switch (infoActionType) {
                case FOLDER: {
                    pnl.add(this.createDirectoryButton(information));
                    break;
                }
                case EMAIL: {
                    pnl.add(this.createEMailButton(information));
                    break;
                }
                default: {
                    pnl.add(new JLabel());
                    break;
                }
            }
        } else {
            pnl.add(new JLabel());
        }
    }

    protected JButton createDirectoryButton(String folder) {
        JButton btnPath = new JButton(Icons.getTangoSVGIcon("places/folder.svg", 16));
        btnPath.addActionListener(e -> this.openDirectory(folder));
        return btnPath;
    }

    protected JButton createEMailButton(String emailAddress) {
        JButton btnEMail = new JButton(Icons.getTangoSVGIcon("actions/mail-message-new.svg", 16));
        btnEMail.addActionListener(e -> this.openEMail(emailAddress));
        return btnEMail;
    }

    protected void openDirectory(String folder) {
        this.openDirectory(Paths.get(folder, new String[0]));
    }

    protected void openDirectory(Path folder) {
        FileExplorerUtil.openDirectory(folder);
    }

    protected void openEMail(String emailAddress) {
        FileExplorerUtil.openEMail(emailAddress);
    }
}

