/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.table.hider;

import ch.supertomcat.supertomcatutils.gui.table.hider.TableColumnHider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class TableColumnHiderSizeBasedImpl
implements TableColumnHider {
    private Map<Object, TableColumnRestoreData> columnsRestoreData = new HashMap<Object, TableColumnRestoreData>();
    private final JTable table;

    public TableColumnHiderSizeBasedImpl(JTable table) {
        this.table = table;
    }

    @Override
    public void hideColumn(Object identifier) {
        TableColumn tableColumn = this.table.getColumn(identifier);
        TableColumnRestoreData tableColumnRestoreData = this.columnsRestoreData.computeIfAbsent(identifier, k -> new TableColumnRestoreData());
        if (!tableColumnRestoreData.isHidden()) {
            tableColumnRestoreData.setMinWidth(tableColumn.getMinWidth());
            tableColumnRestoreData.setMaxWidth(tableColumn.getMaxWidth());
            tableColumnRestoreData.setWidth(tableColumn.getWidth());
            tableColumnRestoreData.setPreferredWidth(tableColumn.getPreferredWidth());
        }
        tableColumnRestoreData.setHidden(true);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setWidth(0);
    }

    @Override
    public void showColumn(Object identifier) {
        TableColumnRestoreData tableColumnRestoreData = this.columnsRestoreData.get(identifier);
        if (tableColumnRestoreData == null || !tableColumnRestoreData.isHidden()) {
            return;
        }
        tableColumnRestoreData.setHidden(false);
        TableColumn tableColumn = this.table.getColumn(identifier);
        tableColumn.setMaxWidth(tableColumnRestoreData.getMaxWidth());
        tableColumn.setMinWidth(tableColumnRestoreData.getMinWidth());
        tableColumn.setPreferredWidth(tableColumnRestoreData.getPreferredWidth());
        tableColumn.setWidth(tableColumnRestoreData.getWidth());
    }

    @Override
    public boolean isVisible(Object identifier) {
        TableColumnRestoreData tableColumnRestoreData = this.columnsRestoreData.get(identifier);
        if (tableColumnRestoreData == null) {
            return true;
        }
        return !tableColumnRestoreData.isHidden();
    }

    private static class TableColumnRestoreData {
        private int width;
        private int minWidth;
        private int maxWidth;
        private int preferredWidth;
        private boolean hidden = false;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public void setMinWidth(int minWidth) {
            this.minWidth = minWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        public void setPreferredWidth(int preferredWidth) {
            this.preferredWidth = preferredWidth;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }
}

