/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.table.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DefaultStringColorRowRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected final Color backgroundColor;
    protected final Color alternateBackgroundColor;
    protected final Color foregroundColor;
    protected final Color alternateForegroundColor;

    public DefaultStringColorRowRenderer() {
        this(Color.WHITE, Color.decode("#F0F8FF"), null, null);
    }

    public DefaultStringColorRowRenderer(Color backgroundColor, Color alternateBackgroundColor, Color foregroundColor, Color alternateForegroundColor) {
        this.backgroundColor = backgroundColor;
        this.alternateBackgroundColor = alternateBackgroundColor;
        this.foregroundColor = foregroundColor;
        this.alternateForegroundColor = alternateForegroundColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.prepareForegroundColor(this, table, value, isSelected, hasFocus, row, column);
        this.prepareBackgroundColor(this, table, value, isSelected, hasFocus, row, column);
        this.prepareValueText(this, table, value, isSelected, hasFocus, row, column);
        this.setOpaque(true);
        return this;
    }

    public void prepareBackgroundColor(Component comp, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color c = isSelected ? table.getSelectionBackground() : (row % 2 != 0 ? (this.alternateBackgroundColor != null ? this.alternateBackgroundColor : table.getBackground()) : (this.backgroundColor != null ? this.backgroundColor : table.getBackground()));
        comp.setBackground(c);
    }

    public void prepareForegroundColor(Component comp, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color c = isSelected ? table.getSelectionForeground() : (row % 2 != 0 ? (this.alternateForegroundColor != null ? this.alternateForegroundColor : table.getForeground()) : (this.foregroundColor != null ? this.foregroundColor : table.getForeground()));
        comp.setForeground(c);
    }

    public void prepareValueText(JLabel label, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String strValue = String.valueOf(value);
        label.setText(strValue);
        label.setToolTipText(strValue);
        label.setIcon(null);
    }
}

