/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.firefox;

import ch.supertomcat.supertomcatutils.http.cookies.BrowserCookie;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirefoxCookies {
    private static final Pattern FIREFOX_TEXTFILE_COOKIE_PATTERN = Pattern.compile("^.*\t(FALSE|TRUE)\t\\/\t(FALSE|TRUE)\t.*\t.*\t.*");
    private static Logger logger = LoggerFactory.getLogger(FirefoxCookies.class);
    private static final Object firefoxCopyDBLock = new Object();
    private static final Object firefoxDBLock = new Object();
    private static long lastFirefoxSqliteCopy = 0L;
    private static FirefoxCookieComparator cookieComparator = new FirefoxCookieComparator();

    private FirefoxCookies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BrowserCookie> getCookiesFromFirefox(String domain, String[] hosts, String[] paths, String cookieFile, String cookieFilev3) {
        logger.debug("Firefox: Cookiefile: {}", (Object)cookieFile);
        logger.debug("Firefox: Cookiefilev3: {}", (Object)cookieFilev3);
        File file = new File(cookieFile);
        File filev3 = new File(cookieFilev3);
        if (filev3.exists() && filev3.getName().endsWith(".sqlite")) {
            logger.debug("Firefox: v3: Cookie file exist, opening database...");
            String newCookieFilev3 = cookieFilev3 + "bh_copy.sqlite";
            Object object = firefoxCopyDBLock;
            synchronized (object) {
                if (System.currentTimeMillis() > lastFirefoxSqliteCopy + 180000L) {
                    CopyUtil.copy(cookieFilev3, newCookieFilev3);
                    lastFirefoxSqliteCopy = System.currentTimeMillis();
                }
            }
            try {
                return FirefoxCookies.getCookiesFromFirefox3Sqlite(newCookieFilev3, domain, hosts, paths, firefoxDBLock, "Firefox: v3");
            }
            catch (ClassNotFoundException | SQLException ex) {
                logger.error("Could not read cookies from: {}", (Object)file.getAbsolutePath(), (Object)ex);
                return new ArrayList<BrowserCookie>();
            }
        }
        if (file.exists() && file.getName().endsWith(".txt")) {
            logger.debug("Firefox: v2: Cookiefile exists, reading in the file...");
            try {
                return FirefoxCookies.getCookiesFromFirefox2TextFile(cookieFile, domain, hosts, paths, "Firefox: v2");
            }
            catch (IOException ex) {
                logger.error("Could not read cookies from: {}", (Object)file.getAbsolutePath(), (Object)ex);
                return new ArrayList<BrowserCookie>();
            }
        }
        return new ArrayList<BrowserCookie>();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<BrowserCookie> getCookiesFromFirefox2TextFile(String cookieFile, String domain, String[] hosts, String[] paths, String browserName) throws IOException {
        try (FileInputStream in = new FileInputStream(cookieFile);){
            ArrayList<BrowserCookie> arrayList;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, Charset.defaultCharset()));){
                ArrayList<BrowserCookie> cookies = new ArrayList<BrowserCookie>();
                String row = null;
                while ((row = br.readLine()) != null) {
                    int n;
                    boolean matchedDomain;
                    if (row.isEmpty() || row.startsWith("# ") || !FIREFOX_TEXTFILE_COOKIE_PATTERN.matcher(row).matches()) continue;
                    String[] cookie = row.split("\t");
                    if (cookie[0].startsWith("#HttpOnly_")) {
                        cookie[0] = cookie[0].substring(10);
                    }
                    if (!(matchedDomain = cookie[0].equals(domain))) {
                        String host;
                        String[] stringArray = hosts;
                        int n2 = stringArray.length;
                        for (n = 0; n < n2 && !(matchedDomain = cookie[0].equals(host = stringArray[n])); ++n) {
                        }
                    }
                    boolean matchedPath = false;
                    String[] stringArray = paths;
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String path = stringArray[i];
                        boolean bl = matchedPath = cookie[2].equals(path) || cookie[2].equals(path + "/");
                        if (matchedPath) break;
                    }
                    if (!matchedDomain || !matchedPath) continue;
                    BrowserCookie browserCookie = new BrowserCookie(cookie[5], cookie[6]);
                    browserCookie.setDomain(cookie[0]);
                    browserCookie.setPath(cookie[2]);
                    browserCookie.setExpiryDate(Instant.ofEpochSecond(Long.parseLong(cookie[4])));
                    browserCookie.setSecure("TRUE".equalsIgnoreCase(cookie[3]));
                    cookies.add(browserCookie);
                }
                logger.debug("{}: Found cookies: {}", (Object)browserName, (Object)cookies.size());
                arrayList = cookies;
            }
            return arrayList;
        }
        catch (IOException e) {
            logger.error("Could not read cookies from file: {}", (Object)cookieFile, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BrowserCookie> getCookiesFromFirefox3Sqlite(String cookieFilev3, String domain, String[] hosts, String[] paths, Object dbLockObject, String browserName) throws ClassNotFoundException, SQLException {
        int i;
        StringBuilder sbSQLQuery = new StringBuilder("SELECT * FROM moz_cookies WHERE (host = '" + domain + "'");
        for (i = 0; i < hosts.length; ++i) {
            sbSQLQuery.append(" OR ");
            sbSQLQuery.append("host = '" + hosts[i] + "'");
        }
        sbSQLQuery.append(")");
        if (paths.length > 0) {
            sbSQLQuery.append(" AND (");
        }
        for (i = 0; i < paths.length; ++i) {
            sbSQLQuery.append("path = '" + paths[i] + "'");
            sbSQLQuery.append(" OR ");
            sbSQLQuery.append("path = '" + paths[i] + "/'");
            if (i >= paths.length - 1) continue;
            sbSQLQuery.append(" OR ");
        }
        if (paths.length > 0) {
            sbSQLQuery.append(")");
        }
        String sqlQuery = sbSQLQuery.toString();
        Class.forName("org.sqlite.JDBC");
        ArrayList<BrowserCookie> cookies = new ArrayList<BrowserCookie>();
        Object object = dbLockObject;
        synchronized (object) {
            logger.debug(browserName + ": SQL-Query: " + sqlQuery);
            try (Connection con = DriverManager.getConnection("jdbc:sqlite:" + cookieFilev3);
                 Statement stat = con.createStatement();
                 ResultSet rs = stat.executeQuery(sqlQuery);){
                while (rs.next()) {
                    String name = rs.getString("name");
                    String value = rs.getString("value");
                    String host = rs.getString("host");
                    String path = rs.getString("path");
                    String strExpiry = rs.getString("expiry");
                    long expiry = Long.parseLong(strExpiry);
                    Instant expiryInstant = Instant.ofEpochSecond(expiry);
                    String strLastAccessed = rs.getString("lastAccessed");
                    String strCreationTime = rs.getString("creationTime");
                    long creationTime = Long.parseLong(strCreationTime);
                    Instant creationTimeInstant = Instant.ofEpochMilli(creationTime);
                    String strSecure = rs.getString("isSecure");
                    boolean secure = "1".equals(strSecure);
                    String strHttpOnly = rs.getString("isHttpOnly");
                    boolean httpOnly = "1".equals(strHttpOnly);
                    BrowserCookie cookie = new BrowserCookie(name, value);
                    cookie.setDomain(host);
                    cookie.setPath(path);
                    cookie.setExpiryDate(expiryInstant);
                    cookie.setCreationDate(creationTimeInstant);
                    cookie.setSecure(secure);
                    cookie.setHttpOnly(httpOnly);
                    cookies.add(cookie);
                }
                logger.debug("{}: Found cookies: {}", (Object)browserName, (Object)cookies.size());
            }
            catch (SQLException se) {
                logger.error("Could not read cookies from file: {}", (Object)cookieFilev3, (Object)se);
                throw se;
            }
        }
        Collections.sort(cookies, cookieComparator);
        return cookies;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getPathForFirefox() {
        Object firefoxPath;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            firefoxPath = System.getenv("APPDATA");
            firefoxPath = (String)firefoxPath + "/Mozilla/Firefox/";
        } else if (os.contains("mac")) {
            firefoxPath = System.getProperty("user.home");
            firefoxPath = (String)firefoxPath + "/Library/Application Support/Firefox/";
        } else {
            firefoxPath = System.getProperty("user.home");
            firefoxPath = (String)firefoxPath + "/.mozilla/firefox/";
        }
        File folder = new File((String)firefoxPath);
        if (!folder.exists()) {
            return "";
        }
        File profilesIniFile = new File((String)firefoxPath, "profiles.ini");
        try (FileInputStream inputStream = new FileInputStream(profilesIniFile);){
            Object object;
            InputStreamReader reader;
            block23: {
                ArrayList<CallSite> paths;
                block22: {
                    reader = new InputStreamReader((InputStream)inputStream, Charset.defaultCharset());
                    try {
                        int defaultProfileIndex = -1;
                        paths = new ArrayList<CallSite>();
                        INIConfiguration ini = new INIConfiguration();
                        ini.read((Reader)reader);
                        for (String sectionName : ini.getSections()) {
                            logger.debug("Found section: {}", (Object)sectionName);
                            if (!sectionName.startsWith("Profile")) continue;
                            logger.debug("Section is a profile: {}", (Object)sectionName);
                            SubnodeConfiguration section = ini.getSection(sectionName);
                            String relative = section.getString("IsRelative", null);
                            String profilePath = section.getString("Path", null);
                            String profileDefault = section.getString("Default", null);
                            if (relative == null || profilePath == null) continue;
                            String absoluteProfilePath = relative.equals("1") ? (String)firefoxPath + profilePath + System.getProperty("file.separator") : profilePath + System.getProperty("file.separator");
                            paths.add((CallSite)((Object)absoluteProfilePath));
                            if (profileDefault == null || !profileDefault.equals("1")) continue;
                            defaultProfileIndex = paths.size() - 1;
                        }
                        if (defaultProfileIndex <= -1) break block22;
                        object = (String)paths.get(defaultProfileIndex);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    reader.close();
                    return object;
                }
                if (paths.isEmpty()) break block23;
                object = (String)paths.get(0);
                reader.close();
                return object;
            }
            object = "";
            reader.close();
            return object;
        }
        catch (IOException | ConfigurationException e) {
            logger.error("Could not read profiles.ini: {}", (Object)profilesIniFile.getAbsolutePath(), (Object)e);
            return "";
        }
    }

    private static class FirefoxCookieComparator
    implements Comparator<BrowserCookie> {
        private FirefoxCookieComparator() {
        }

        @Override
        public int compare(BrowserCookie o1, BrowserCookie o2) {
            int nameComp = o1.getName().compareTo(o2.getName());
            if (nameComp == 0) {
                if (o1.getPath().length() > o2.getPath().length()) {
                    return -1;
                }
                if (o1.getPath().length() < o2.getPath().length()) {
                    return 1;
                }
                if (o1.getDomain().equals("." + o2.getDomain())) {
                    return 1;
                }
                if (o2.getDomain().equals("." + o1.getDomain())) {
                    return -1;
                }
            }
            return nameComp;
        }
    }
}

