/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.palemoon;

import ch.supertomcat.supertomcatutils.http.cookies.BrowserCookie;
import ch.supertomcat.supertomcatutils.http.cookies.firefox.FirefoxCookies;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaleMoonCookies {
    private static Logger logger = LoggerFactory.getLogger(PaleMoonCookies.class);
    private static final Object paleMoonCopyDBLock = new Object();
    private static final Object paleMoonDBLock = new Object();
    private static long lastPaleMoonSqliteCopy = 0L;

    private PaleMoonCookies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BrowserCookie> getCookiesFromPaleMoon(String domain, String[] hosts, String[] paths, String cookieFile) {
        logger.debug("Pale Moon: Cookiefile: {}", (Object)cookieFile);
        File file = new File(cookieFile);
        if (file.exists() && file.getName().endsWith(".sqlite")) {
            logger.debug("Pale Moon: Cookie file exist, opening database...");
            String newCookieFile = cookieFile + "bh_copy.sqlite";
            Object object = paleMoonCopyDBLock;
            synchronized (object) {
                if (System.currentTimeMillis() > lastPaleMoonSqliteCopy + 180000L) {
                    CopyUtil.copy(cookieFile, newCookieFile);
                    lastPaleMoonSqliteCopy = System.currentTimeMillis();
                }
            }
            try {
                return PaleMoonCookies.getCookiesFromPaleMoonSqlite(newCookieFile, domain, hosts, paths);
            }
            catch (ClassNotFoundException | SQLException ex) {
                logger.error("Could not read cookies from: {}", (Object)file.getAbsolutePath(), (Object)ex);
                return new ArrayList<BrowserCookie>();
            }
        }
        return new ArrayList<BrowserCookie>();
    }

    private static List<BrowserCookie> getCookiesFromPaleMoonSqlite(String cookieFile, String domain, String[] hosts, String[] paths) throws ClassNotFoundException, SQLException {
        return FirefoxCookies.getCookiesFromFirefox3Sqlite(cookieFile, domain, hosts, paths, paleMoonDBLock, "Pale Moon");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getPathForPaleMoon() {
        Object paleMoonPath;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            paleMoonPath = System.getenv("APPDATA");
            paleMoonPath = (String)paleMoonPath + "/Moonchild Productions/Pale Moon/";
        } else if (os.contains("mac")) {
            paleMoonPath = System.getProperty("user.home");
            paleMoonPath = (String)paleMoonPath + "/Library/Application Support/Pale Moon/";
        } else {
            paleMoonPath = System.getProperty("user.home");
            paleMoonPath = (String)paleMoonPath + "/.moonchild productions/pale moon/";
        }
        File folder = new File((String)paleMoonPath);
        if (!folder.exists()) {
            return "";
        }
        File profilesIniFile = new File((String)paleMoonPath, "profiles.ini");
        try (FileInputStream inputStream = new FileInputStream(profilesIniFile);){
            Object object;
            InputStreamReader reader;
            block23: {
                ArrayList<CallSite> paths;
                block22: {
                    reader = new InputStreamReader((InputStream)inputStream, Charset.defaultCharset());
                    try {
                        int defaultProfileIndex = -1;
                        paths = new ArrayList<CallSite>();
                        INIConfiguration ini = new INIConfiguration();
                        ini.read((Reader)reader);
                        for (String sectionName : ini.getSections()) {
                            logger.debug("Found section: {}", (Object)sectionName);
                            if (!sectionName.startsWith("Profile")) continue;
                            logger.debug("Section is a profile: {}", (Object)sectionName);
                            SubnodeConfiguration section = ini.getSection(sectionName);
                            String relative = section.getString("IsRelative", null);
                            String profilePath = section.getString("Path", null);
                            String profileDefault = section.getString("Default", null);
                            if (relative == null || profilePath == null) continue;
                            String absoluteProfilePath = relative.equals("1") ? (String)paleMoonPath + profilePath + System.getProperty("file.separator") : profilePath + System.getProperty("file.separator");
                            paths.add((CallSite)((Object)absoluteProfilePath));
                            if (profileDefault == null || !profileDefault.equals("1")) continue;
                            defaultProfileIndex = paths.size() - 1;
                        }
                        if (defaultProfileIndex <= -1) break block22;
                        object = (String)paths.get(defaultProfileIndex);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    reader.close();
                    return object;
                }
                if (paths.isEmpty()) break block23;
                object = (String)paths.get(0);
                reader.close();
                return object;
            }
            object = "";
            reader.close();
            return object;
        }
        catch (IOException | ConfigurationException e) {
            logger.error("Could not read profiles.ini: {}", (Object)profilesIniFile.getAbsolutePath(), (Object)e);
            return "";
        }
    }
}

