/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.image;

import java.awt.Image;
import java.awt.image.ImageObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSizeWaiter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Image image;
    private final Object syncObject = new Object();
    private boolean sizeAvailable = false;
    private boolean error = false;

    public ImageSizeWaiter(Image image) {
        this.image = image;
    }

    public boolean waitForSize() {
        return this.waitForSize(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSize(long timeout) {
        Object object = this.syncObject;
        synchronized (object) {
            ImageObserver observer = new ImageObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    if ((infoflags & 3) != 0) {
                        Object object = ImageSizeWaiter.this.syncObject;
                        synchronized (object) {
                            ImageSizeWaiter.this.sizeAvailable = true;
                            ImageSizeWaiter.this.syncObject.notifyAll();
                        }
                        return false;
                    }
                    if ((infoflags & 0x20) != 0) {
                        Object object = ImageSizeWaiter.this.syncObject;
                        synchronized (object) {
                            ImageSizeWaiter.this.sizeAvailable = true;
                            ImageSizeWaiter.this.syncObject.notifyAll();
                        }
                        return false;
                    }
                    if ((infoflags & 0xC0) != 0) {
                        Object object = ImageSizeWaiter.this.syncObject;
                        synchronized (object) {
                            ImageSizeWaiter.this.error = true;
                            ImageSizeWaiter.this.syncObject.notifyAll();
                        }
                        return false;
                    }
                    return true;
                }
            };
            int width = this.image.getWidth(observer);
            int height = this.image.getHeight(observer);
            if (width > -1 && height > -1) {
                return true;
            }
            while (!this.sizeAvailable && !this.error) {
                try {
                    this.syncObject.wait(timeout);
                    if (this.sizeAvailable) {
                        return true;
                    }
                    if (this.error) {
                        return false;
                    }
                    if (timeout <= 0L) continue;
                    return false;
                }
                catch (InterruptedException e) {
                    this.logger.error("Wait for image size available was interrupted", (Throwable)e);
                    return false;
                }
            }
            return this.sizeAvailable;
        }
    }
}

