/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.image;

import ch.supertomcat.supertomcatutils.http.HTTPUtil;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageUtil.class);

    private ImageUtil() {
    }

    public static BufferedImage downloadImage(String url, int connectTimeout, int readTimeout) throws IOException {
        URLConnection con = HTTPUtil.parseURL(url).openConnection();
        con.setConnectTimeout(connectTimeout);
        con.setReadTimeout(readTimeout);
        try (InputStream in = con.getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
    }

    public static BufferedImage downloadImage(String url, BufferedImage defaultImage, int connectTimeout, int readTimeout, boolean logStackTrace) {
        try {
            BufferedImage img = ImageUtil.downloadImage(url, connectTimeout, readTimeout);
            return img != null ? img : defaultImage;
        }
        catch (MalformedURLException e) {
            if (logStackTrace) {
                logger.error("ImageUtil: Image URL is malformed: {}", (Object)url, (Object)e);
            } else {
                logger.error("ImageUtil: Image URL is malformed: '{}'. Error: {}", (Object)url, (Object)e.getMessage());
            }
        }
        catch (IOException e) {
            if (logStackTrace) {
                logger.error("ImageUtil: Image could not be downloaded: {}", (Object)url, (Object)e);
            }
            logger.error("ImageUtil: Image could not be downloaded: '{}'. Error: {}", (Object)url, (Object)e.getMessage());
        }
        return defaultImage;
    }

    public static byte[] downloadImageRaw(String url, int connectTimeout, int readTimeout) throws IOException {
        URLConnection con = HTTPUtil.parseURL(url).openConnection();
        con.setConnectTimeout(connectTimeout);
        con.setReadTimeout(readTimeout);
        try (InputStream in = con.getInputStream();){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CopyUtil.copy(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage generatePreviewImage(Image img, int width, int height) {
        return ImageUtil.generatePreviewImage(img, width, height, 1);
    }

    public static BufferedImage generatePreviewImage(Image img, int width, int height, int hints) {
        return ImageUtil.generatePreviewImage(img, width, height, hints, 1);
    }

    public static BufferedImage generatePreviewImage(Image img, int width, int height, int hints, int type) {
        Dimension dim = ImageUtil.waitForImageDimension(img);
        int origWidth = dim.width;
        int origHeight = dim.height;
        int newWidth = width;
        int newHeight = height;
        if (width < 0) {
            scaleFactor = (float)height / (float)origHeight;
            newWidth = (int)((float)origWidth * scaleFactor);
        } else if (height < 0) {
            scaleFactor = (float)width / (float)origWidth;
            newHeight = (int)((float)origHeight * scaleFactor);
        }
        Image imgScaled = img.getScaledInstance(width, height, hints);
        if (imgScaled instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)imgScaled;
            return bufferedImage;
        }
        BufferedImage imgScaledBuffered = new BufferedImage(newWidth, newHeight, type);
        Graphics2D bGr = imgScaledBuffered.createGraphics();
        bGr.drawImage(imgScaled, 0, 0, null);
        bGr.dispose();
        return imgScaledBuffered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension waitForImageDimension(Image img) {
        DimensionValue imgHeight;
        ImageObserver imgHeightObserver;
        int tmpHeight;
        final DimensionValue imgWidth = new DimensionValue();
        ImageObserver imgWidthObserver = new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (width == -1) {
                    return true;
                }
                imgWidth.setValue(width);
                return false;
            }
        };
        int tmpWidth = img.getWidth(imgWidthObserver);
        if (tmpWidth == -1) {
            DimensionValue dimensionValue = imgWidth;
            synchronized (dimensionValue) {
                while (!imgWidth.isValueSet()) {
                    try {
                        imgWidth.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                tmpWidth = imgWidth.getValue();
            }
        }
        if ((tmpHeight = img.getHeight(imgHeightObserver = new ImageObserver(imgHeight = new DimensionValue()){
            final /* synthetic */ DimensionValue val$imgHeight;
            {
                this.val$imgHeight = dimensionValue;
            }

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (height == -1) {
                    return true;
                }
                this.val$imgHeight.setValue(height);
                return false;
            }
        })) == -1) {
            DimensionValue dimensionValue = imgHeight;
            synchronized (dimensionValue) {
                while (!imgHeight.isValueSet()) {
                    try {
                        imgHeight.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                tmpHeight = imgHeight.getValue();
            }
        }
        return new Dimension(tmpWidth, tmpHeight);
    }

    private static class DimensionValue {
        private int value;
        private boolean valueSet = false;

        private DimensionValue() {
        }

        public boolean isValueSet() {
            return this.valueSet;
        }

        public int getValue() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(int value) {
            this.value = value;
            this.valueSet = true;
            DimensionValue dimensionValue = this;
            synchronized (dimensionValue) {
                this.notifyAll();
            }
        }
    }
}

