/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryUtil {
    private static Logger logger = LoggerFactory.getLogger(DirectoryUtil.class);

    private DirectoryUtil() {
    }

    public static void copyDirectoryRecursive(final Path sourceDirectory, final Path targetDirectory) throws IOException {
        Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetSubFolder = targetDirectory.resolve(sourceDirectory.relativize(dir).toString());
                logger.info("Create Directories: {}", (Object)targetSubFolder);
                Files.createDirectories(targetSubFolder, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = targetDirectory.resolve(sourceDirectory.relativize(file).toString());
                logger.info("Copy '{}' to '{}'", (Object)file, (Object)targetFile);
                Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void clearDirectoryRecursive(Path directory) throws IOException {
        DirectoryUtil.deleteDirectoryRecursive(directory, false);
    }

    public static void deleteDirectoryRecursive(Path directory) throws IOException {
        DirectoryUtil.deleteDirectoryRecursive(directory, true);
    }

    public static void deleteDirectoryRecursive(final Path directory, final boolean deleteGivenDirectory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                logger.info("Delete File: {}", (Object)file);
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!deleteGivenDirectory && directory.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                logger.info("Delete Directory: {}", (Object)dir);
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

