/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.queue;

import ch.supertomcat.supertomcatutils.queue.QueueManagerBaseThreadFactory;
import ch.supertomcat.supertomcatutils.queue.QueueTask;
import ch.supertomcat.supertomcatutils.queue.QueueTaskFactory;
import ch.supertomcat.supertomcatutils.queue.Restriction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueManagerBase<T, R> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Object syncObject = new Object();
    protected final List<T> queue = new ArrayList<T>();
    protected final QueueTaskFactory<T, R> queueTaskFactory;
    protected final List<QueueTask<T, R>> executingTasks = new ArrayList<QueueTask<T, R>>();
    protected boolean checkScheduleTasks = true;
    protected final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
    protected Thread schedulerThread = null;
    protected Thread queueCompletionThread = null;
    protected int maxConnectionCount;
    protected int maxConnectionCountPerHost;
    protected int sessionFiles = 0;
    protected long sessionBytes = 0L;
    protected int openSlots;
    protected ThreadPoolExecutor threadPool = null;
    protected CompletionService<R> completionService = null;
    protected volatile boolean stop = false;

    public QueueManagerBase(QueueTaskFactory<T, R> queueTaskFactory, int maxConnectionCount, int maxConnectionCountPerHost) {
        this.queueTaskFactory = queueTaskFactory;
        this.maxConnectionCount = maxConnectionCount;
        this.maxConnectionCountPerHost = maxConnectionCountPerHost;
        this.openSlots = maxConnectionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.schedulerThread != null && this.schedulerThread.isAlive()) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.stop = false;
            this.checkScheduleTasks = true;
            for (Map.Entry<String, AtomicInteger> entry : this.counters.entrySet()) {
                entry.getValue().set(0);
            }
            this.threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool(new QueueManagerBaseThreadFactory("BaseQueueThread-"));
            this.completionService = new ExecutorCompletionService<R>(this.threadPool);
            this.applyMaxConnectionCount();
        }
        this.schedulerThread = new Thread(new QueueSchedulerThread());
        this.schedulerThread.setName("QueueSchedulerThread-" + this.schedulerThread.threadId());
        this.schedulerThread.start();
        this.queueCompletionThread = new Thread(new QueueCompletionThread());
        this.queueCompletionThread.setName("QueueCompletionThread-" + this.queueCompletionThread.threadId());
        this.queueCompletionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.schedulerThread == null) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.stop = true;
            this.cancelTasks(true);
            this.threadPool.shutdownNow();
            this.checkScheduleTasks = true;
            this.syncObject.notifyAll();
        }
        try {
            this.schedulerThread.join();
        }
        catch (InterruptedException e) {
            this.logger.error("Wait for scheduler thread to finish was interrupted", (Throwable)e);
        }
        this.queueCompletionThread.interrupt();
        try {
            this.queueCompletionThread.join();
        }
        catch (InterruptedException e) {
            this.logger.error("Wait for queue completion thread to finish was interrupted", (Throwable)e);
        }
        try {
            this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("Wait for thread pool to finish was interrupted", (Throwable)e);
        }
        this.removeTaskCallables();
        this.schedulerThread = null;
        this.queueCompletionThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancelTasks(boolean cancelAlreadyExecutingTasks) {
        Object object = this.syncObject;
        synchronized (object) {
            for (T task : this.queue) {
                this.removedTaskFromQueue(task, false);
            }
            this.queue.clear();
            if (cancelAlreadyExecutingTasks) {
                this.cancelTaskCallables(true);
            }
            this.checkScheduleTasks = true;
            this.syncObject.notifyAll();
        }
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public int getMaxConnectionCountPerHost() {
        return this.maxConnectionCountPerHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConnectionCount(int maxConnectionCount) {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.maxConnectionCount == maxConnectionCount) {
                return;
            }
            this.maxConnectionCount = maxConnectionCount;
            this.applyMaxConnectionCount();
            this.updateOpenSlots(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyMaxConnectionCount() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.threadPool != null) {
                this.threadPool.setCorePoolSize(this.maxConnectionCount);
                this.threadPool.setMaximumPoolSize(this.maxConnectionCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConnectionCountPerHost(int maxConnectionCountPerHost) {
        Object object = this.syncObject;
        synchronized (object) {
            this.maxConnectionCountPerHost = maxConnectionCountPerHost;
        }
    }

    public int getSessionFiles() {
        return this.sessionFiles;
    }

    public synchronized void increaseSessionFiles() {
        ++this.sessionFiles;
    }

    public long getSessionBytes() {
        return this.sessionBytes;
    }

    public synchronized void increaseSessionBytes(long bytes) {
        this.sessionBytes += bytes;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getTaskCount() {
        return this.executingTasks.size();
    }

    public boolean isExecutingTasks() {
        return !this.queue.isEmpty() && !this.executingTasks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOpenSlots(boolean taskFinished) {
        Object object = this.syncObject;
        synchronized (object) {
            int openSlotsTemp = this.maxConnectionCount - this.executingTasks.size();
            if (openSlotsTemp < 0) {
                this.openSlots = 0;
                return;
            }
            this.openSlots = openSlotsTemp;
        }
    }

    public int getOpenSlots() {
        return this.openSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToQueue(T task) {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.queue.contains(task)) {
                this.queue.add(task);
                this.checkScheduleTasks = true;
                this.syncObject.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTasksToQueue(List<T> tasks) {
        Object object = this.syncObject;
        synchronized (object) {
            for (T task : tasks) {
                if (this.queue.contains(task)) continue;
                this.queue.add(task);
            }
            this.checkScheduleTasks = true;
            this.syncObject.notifyAll();
        }
    }

    protected abstract void removedTaskFromQueue(T var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTaskToExecutingTasks(QueueTask<T, R> task) {
        Object object = this.syncObject;
        synchronized (object) {
            this.executingTasks.add(task);
            this.updateOpenSlots(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTaskCallables(boolean interruptTaskIfRunning) {
        Object object = this.syncObject;
        synchronized (object) {
            for (QueueTask<T, R> task : this.executingTasks) {
                task.getFuture().cancel(interruptTaskIfRunning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTaskCallables() {
        Object object = this.syncObject;
        synchronized (object) {
            Iterator<QueueTask<T, R>> it = this.executingTasks.iterator();
            while (it.hasNext()) {
                QueueTask<T, R> task = it.next();
                if (task.getFuture() == null || !task.getFuture().isDone()) continue;
                Restriction restriction = this.getRestrictionForTask(task.getTask());
                String restrictionKey = restriction.getRestrictionKey();
                AtomicInteger count = this.counters.get(restrictionKey);
                if (count != null) {
                    count.updateAndGet(value -> value > 0 ? value - 1 : value);
                }
                this.completedTaskCallable(task);
                it.remove();
            }
            this.updateOpenSlots(false);
            this.checkScheduleTasks = true;
            this.syncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTaskCallable(Future<R> future) {
        Object object = this.syncObject;
        synchronized (object) {
            QueueTask<T, R> taskForFuture = null;
            for (QueueTask<T, R> task : this.executingTasks) {
                if (!future.equals(task.getFuture())) continue;
                taskForFuture = task;
                break;
            }
            if (taskForFuture != null) {
                Restriction restriction = this.getRestrictionForTask(taskForFuture.getTask());
                String restrictionKey = restriction.getRestrictionKey();
                AtomicInteger count = this.counters.get(restrictionKey);
                if (count != null) {
                    count.updateAndGet(value -> value > 0 ? value - 1 : value);
                }
                this.completedTaskCallable(taskForFuture);
                this.executingTasks.remove(taskForFuture);
            } else {
                this.logger.error("Task not found for future: {}", future);
            }
            this.updateOpenSlots(true);
            this.checkScheduleTasks = true;
            this.syncObject.notifyAll();
        }
    }

    protected abstract void completedTaskCallable(QueueTask<T, R> var1);

    protected abstract Restriction getRestrictionForTask(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRestrictedCount(String restrictionKey) {
        Object object = this.syncObject;
        synchronized (object) {
            AtomicInteger count = this.counters.get(restrictionKey);
            if (count != null) {
                return count.get();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxConnectionCount(T task) {
        Restriction restriction = this.getRestrictionForTask(task);
        int max = restriction.getMaxConnectionCount();
        Object object = this.syncObject;
        synchronized (object) {
            if (max <= 0 || max > this.maxConnectionCountPerHost) {
                max = this.maxConnectionCountPerHost;
            }
        }
        return max;
    }

    private class QueueSchedulerThread
    implements Runnable {
        private QueueSchedulerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!QueueManagerBase.this.stop) {
                Object object = QueueManagerBase.this.syncObject;
                synchronized (object) {
                    while (!QueueManagerBase.this.checkScheduleTasks || QueueManagerBase.this.queue.isEmpty() || QueueManagerBase.this.executingTasks.size() >= QueueManagerBase.this.maxConnectionCount) {
                        try {
                            QueueManagerBase.this.syncObject.wait();
                        }
                        catch (InterruptedException e) {
                            QueueManagerBase.this.logger.error("Wait for open slot was interrupted");
                        }
                        if (!QueueManagerBase.this.stop) continue;
                    }
                    Iterator itQueue = QueueManagerBase.this.queue.iterator();
                    while (itQueue.hasNext() && QueueManagerBase.this.executingTasks.size() < QueueManagerBase.this.maxConnectionCount) {
                        Object task = itQueue.next();
                        Restriction restriction = QueueManagerBase.this.getRestrictionForTask(task);
                        String restrictionKey = restriction.getRestrictionKey();
                        AtomicInteger count = QueueManagerBase.this.counters.get(restrictionKey);
                        if (count == null) {
                            count = new AtomicInteger();
                            QueueManagerBase.this.counters.put(restrictionKey, count);
                        }
                        int currentCountPerHost = count.get();
                        int maxCountPerHost = QueueManagerBase.this.getMaxConnectionCount(task);
                        if (maxCountPerHost > 0 && currentCountPerHost >= maxCountPerHost) continue;
                        itQueue.remove();
                        count.incrementAndGet();
                        QueueTask taskCallable = QueueManagerBase.this.queueTaskFactory.createTaskCallable(task);
                        try {
                            Future future = QueueManagerBase.this.completionService.submit(taskCallable);
                            taskCallable.setFuture(future);
                            QueueManagerBase.this.addTaskToExecutingTasks(taskCallable);
                        }
                        catch (Exception e) {
                            QueueManagerBase.this.logger.error("Could not schedule task: {}", task, (Object)e);
                            QueueManagerBase.this.removedTaskFromQueue(task, true);
                        }
                    }
                    QueueManagerBase.this.checkScheduleTasks = false;
                }
            }
        }
    }

    private class QueueCompletionThread
    implements Runnable {
        private QueueCompletionThread() {
        }

        @Override
        public void run() {
            while (!QueueManagerBase.this.stop) {
                try {
                    Future future = QueueManagerBase.this.completionService.take();
                    QueueManagerBase.this.removeTaskCallable(future);
                }
                catch (InterruptedException e) {
                    if (QueueManagerBase.this.stop) continue;
                    QueueManagerBase.this.logger.error("Wait for task to complete was interrupted");
                }
            }
        }
    }
}

