/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.settings;

public final class SettingsUtil {
    private SettingsUtil() {
    }

    public static Object parseValue(String dataType, String strValue) {
        if (dataType.equals("boolean")) {
            return SettingsUtil.parseBooleanValue(strValue, false);
        }
        if (dataType.equals("int")) {
            return SettingsUtil.parseIntValue(strValue, 0);
        }
        if (dataType.equals("long")) {
            return SettingsUtil.parseLongValue(strValue, 0L);
        }
        if (dataType.equals("string")) {
            return strValue;
        }
        if (dataType.equals("byte")) {
            return SettingsUtil.parseByteValue(strValue, (byte)0);
        }
        if (dataType.equals("short")) {
            return SettingsUtil.parseShortValue(strValue, (short)0);
        }
        if (dataType.equals("float")) {
            return Float.valueOf(SettingsUtil.parseFloatValue(strValue, 0.0f));
        }
        if (dataType.equals("double")) {
            return SettingsUtil.parseDoubleValue(strValue, 0.0);
        }
        throw new IllegalArgumentException("Data Type is not supported: " + dataType);
    }

    public static int parseIntValue(String value, int defVal) {
        if (value == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static long parseLongValue(String value, long defVal) {
        if (value == null) {
            return defVal;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static boolean parseBooleanValue(String value, boolean defVal) {
        if (value == null) {
            return defVal;
        }
        return Boolean.parseBoolean(value);
    }

    public static short parseShortValue(String value, short defVal) {
        if (value == null) {
            return defVal;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static byte parseByteValue(String value, byte defVal) {
        if (value == null) {
            return defVal;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static float parseFloatValue(String value, float defVal) {
        if (value == null) {
            return defVal;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static double parseDoubleValue(String value, double defVal) {
        if (value == null) {
            return defVal;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static <E> String getValueDataType(E value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        if (valueType == Boolean.class) {
            return "boolean";
        }
        if (valueType == Byte.class) {
            return "byte";
        }
        if (valueType == Double.class) {
            return "double";
        }
        if (valueType == Float.class) {
            return "float";
        }
        if (valueType == Integer.class) {
            return "int";
        }
        if (valueType == Long.class) {
            return "long";
        }
        if (valueType == Short.class) {
            return "short";
        }
        if (valueType == String.class) {
            return "string";
        }
        return null;
    }

    public static <E> String getValueAsString(E value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        if (valueType == Boolean.class) {
            return String.valueOf((Boolean)value);
        }
        if (valueType == Byte.class) {
            return String.valueOf(((Byte)value).byteValue());
        }
        if (valueType == Double.class) {
            return String.valueOf((Double)value);
        }
        if (valueType == Float.class) {
            return String.valueOf(((Float)value).floatValue());
        }
        if (valueType == Integer.class) {
            return String.valueOf((Integer)value);
        }
        if (valueType == Long.class) {
            return String.valueOf((Long)value);
        }
        if (valueType == Short.class) {
            return String.valueOf(((Short)value).shortValue());
        }
        if (valueType == String.class) {
            return (String)value;
        }
        return null;
    }
}

