/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.application;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.application.ApplicationUtil;
import ch.supertomcat.supertomcatutils.io.FileUtil;
import com.sun.jna.Platform;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.LoggerFactory;

public abstract class ApplicationMain {
    public static final String APPLICATION_NAME = "ApplicationName";
    public static final String APPLICATION_SHORT_NAME = "ApplicationShortName";
    public static final String APPLICATION_VERSION = "ApplicationVersion";
    public static final String APPLICATION_PATH = "ApplicationPath";
    public static final String PROGRAM_DATA_PATH = "ProgramDataPath";
    public static final String JAR_FILENAME = "JarFilename";
    public static final String PROFILE_PATH = "ProfilePath";
    public static final String LOGS_PATH = "LogsPath";
    public static final String LICENSE_NAME = "LicenseName";
    public static final String LICENSE_TEXT = "LicenseText";
    public static final String DATABASE_PATH = "DatabasePath";
    public static final String SETTINGS_PATH = "SettingsPath";
    protected final String applicationShortName;
    protected final Image applicationIcon;
    protected final boolean gui;
    protected final boolean singleInstance;
    protected final Class<?> mainClass;
    protected final Set<String> additionalPaths = new LinkedHashSet<String>();
    protected final Set<String> overwritablePaths = new LinkedHashSet<String>();
    protected final List<Thread> shutdownHookThreads = new CopyOnWriteArrayList<Thread>();

    public ApplicationMain(String applicationShortName, Image applicationIcon, boolean gui, boolean singleInstance, Class<?> mainClass) {
        this(applicationShortName, applicationIcon, gui, singleInstance, mainClass, Collections.emptyList(), Collections.emptyList());
    }

    public ApplicationMain(String applicationShortName, Image applicationIcon, boolean gui, boolean singleInstance, Class<?> mainClass, List<String> additionalPaths) {
        this(applicationShortName, applicationIcon, gui, singleInstance, mainClass, additionalPaths, Collections.emptyList());
    }

    public ApplicationMain(String applicationShortName, Image applicationIcon, boolean gui, boolean singleInstance, Class<?> mainClass, List<String> additionalPaths, List<String> overwritablePaths) {
        this.applicationShortName = applicationShortName;
        this.applicationIcon = applicationIcon;
        this.gui = gui;
        this.singleInstance = singleInstance;
        this.mainClass = mainClass;
        this.additionalPaths.addAll(additionalPaths);
        if (overwritablePaths.isEmpty()) {
            this.overwritablePaths.add(LOGS_PATH);
            this.overwritablePaths.addAll(additionalPaths);
        } else {
            this.overwritablePaths.addAll(overwritablePaths);
        }
    }

    public void start(String[] args) {
        this.initializeApplicationProperties();
        String jarFilename = this.getJarFilename();
        String applicationPath = this.getApplicationPath();
        this.initializeJarFilenameAndApplicationPathProperties(jarFilename, applicationPath);
        String programUserDir = System.getProperty("user.home") + FileUtil.FILE_SEPERATOR + "." + ApplicationProperties.getProperty(APPLICATION_SHORT_NAME) + FileUtil.FILE_SEPERATOR;
        this.initializeProfileAndLogsPathProperties(programUserDir);
        this.initializeProgramDataPathProperties(applicationPath, programUserDir);
        this.initializeAdditionalPathProperties(programUserDir);
        this.parseDefaultCommandLine(args);
        this.overrideDirectoryProperties();
        this.initializeLogging();
        if (this.singleInstance) {
            this.ensureSingleInstance(programUserDir, ApplicationProperties.getProperty(APPLICATION_SHORT_NAME) + ".lock");
        }
        ApplicationUtil.logApplicationInfo();
        this.deleteOldLogFiles();
        if (this.gui) {
            this.setSystemLookAndFeel();
        }
        this.main(args);
    }

    public void exit() {
        this.exit(0, false);
    }

    public void exit(boolean restart) {
        this.exit(0, restart);
    }

    public void exit(int exitCode) {
        this.exit(exitCode, false);
    }

    public void exit(int exitCode, boolean restart) {
        if (this.singleInstance) {
            this.releaseSingleInstanceLockFile();
        }
        if (restart) {
            this.restartApplication();
        }
        this.exitNow(exitCode);
    }

    protected boolean restartApplication() {
        String jarFilename = ApplicationProperties.getProperty(JAR_FILENAME);
        if (jarFilename == null || jarFilename.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).error("Could not restart application: JarFilename Application Property is null or empty: {}", (Object)jarFilename);
            return false;
        }
        try {
            String javaExePath;
            Object applicationAbsolutePath = Paths.get(ApplicationProperties.getProperty(APPLICATION_PATH), new String[0]).toAbsolutePath().toString();
            if (!((String)applicationAbsolutePath).endsWith(FileUtil.FILE_SEPERATOR)) {
                applicationAbsolutePath = (String)applicationAbsolutePath + FileUtil.FILE_SEPERATOR;
            }
            if ((javaExePath = this.getJavaExePath()) == null) {
                LoggerFactory.getLogger(this.getClass()).error("Could not restart application: Could not find java executable");
                return false;
            }
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(javaExePath);
            arguments.add("-jar");
            arguments.add((String)applicationAbsolutePath + ApplicationProperties.getProperty(JAR_FILENAME));
            new ProcessBuilder(arguments).start();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not restart application", (Throwable)e);
            return false;
        }
    }

    protected String getJavaExePath() {
        Path fJreJava;
        Path fJreJavaw;
        String jreBinPath = System.getProperty("java.home") + FileUtil.FILE_SEPERATOR + "bin" + FileUtil.FILE_SEPERATOR;
        String jreJavaw = jreBinPath + "javaw";
        String jreJava = jreBinPath + "java";
        if (Platform.isWindows()) {
            fJreJavaw = Paths.get(jreJavaw + ".exe", new String[0]);
            fJreJava = Paths.get(jreJava + ".exe", new String[0]);
        } else {
            fJreJavaw = Paths.get(jreJavaw, new String[0]);
            fJreJava = Paths.get(jreJava, new String[0]);
        }
        if (Files.exists(fJreJavaw, new LinkOption[0])) {
            return jreJavaw;
        }
        if (Files.exists(fJreJava, new LinkOption[0])) {
            return jreJava;
        }
        return null;
    }

    protected void exitNow(int exitCode) {
        LoggerFactory.getLogger(this.getClass()).debug("Exit now!");
        System.exit(exitCode);
    }

    protected void initializeApplicationProperties() {
        try (InputStream in = this.mainClass.getResourceAsStream("/Application_Config.properties");){
            ApplicationProperties.initProperties(in);
        }
        catch (IOException e) {
            this.logStartupError("Could not initialize application properties", e);
            System.exit(1);
        }
    }

    protected String getJarFilename() {
        return ApplicationUtil.getThisApplicationsJarFilename(this.mainClass);
    }

    protected String getApplicationPath() {
        String jarFilename = ApplicationUtil.getThisApplicationsJarFilename(this.mainClass);
        return ApplicationUtil.getThisApplicationsPath((String)(!jarFilename.isEmpty() ? jarFilename : ApplicationProperties.getProperty(APPLICATION_SHORT_NAME) + ".jar"));
    }

    protected void initializeJarFilenameAndApplicationPathProperties(String jarFilename, String applicationPath) {
        ApplicationProperties.setProperty(JAR_FILENAME, jarFilename);
        ApplicationProperties.setProperty(APPLICATION_PATH, applicationPath);
    }

    protected void initializeProfileAndLogsPathProperties(String programUserDir) {
        ApplicationProperties.setProperty(PROFILE_PATH, programUserDir);
        ApplicationProperties.setProperty(LOGS_PATH, programUserDir);
    }

    protected void initializeProgramDataPathProperties(String applicationPath, String programUserDir) {
        String programDataEnvPath;
        Object programDataPath = Platform.isWindows() ? ((programDataEnvPath = System.getenv("ProgramData")) != null ? programDataEnvPath + FileUtil.FILE_SEPERATOR + ApplicationProperties.getProperty(APPLICATION_NAME) + FileUtil.FILE_SEPERATOR : applicationPath) : applicationPath;
        ApplicationProperties.setProperty(PROGRAM_DATA_PATH, (String)programDataPath);
    }

    protected void initializeAdditionalPathProperties(String programUserDir) {
        for (String additionalPath : this.additionalPaths) {
            ApplicationProperties.setProperty(additionalPath, programUserDir);
        }
    }

    protected void overrideDirectoryProperties() {
        try {
            Properties directoriesProperties = this.readDirectoriesFile();
            if (directoriesProperties == null) {
                return;
            }
            for (String overwriteablePath : this.overwritablePaths) {
                String dir = directoriesProperties.getProperty(overwriteablePath);
                if (dir == null || dir.isEmpty()) continue;
                ApplicationProperties.setProperty(overwriteablePath, dir);
            }
        }
        catch (IOException e) {
            this.logStartupError("Could not read directories.properties", e);
            System.exit(1);
        }
    }

    protected Properties readDirectoriesFile() throws IOException {
        Path file = Paths.get(ApplicationProperties.getProperty(APPLICATION_PATH) + "directories.properties", new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        String content = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        Properties directoriesProperties = new Properties();
        directoriesProperties.load(new StringReader(content.replace("\\", "\\\\")));
        return directoriesProperties;
    }

    protected void initializeLogging() {
        String logFilename = ApplicationProperties.getProperty(APPLICATION_SHORT_NAME) + ".log";
        System.setProperty("applicationlog4jlogfile", ApplicationProperties.getProperty(LOGS_PATH) + FileUtil.FILE_SEPERATOR + logFilename);
        LoggerFactory.getLogger(this.mainClass);
        ApplicationUtil.initializeSLF4JUncaughtExceptionHandler();
    }

    protected void parseDefaultCommandLine(String[] args) {
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-version")) {
                System.out.print(ApplicationProperties.getProperty(APPLICATION_VERSION));
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("-versionNumber")) {
                System.out.print(ApplicationProperties.getProperty(APPLICATION_VERSION).replace(".", ""));
                System.exit(0);
                continue;
            }
            if (!arg.equalsIgnoreCase("-help")) continue;
            String help = ApplicationProperties.getProperty(APPLICATION_NAME) + " v" + ApplicationProperties.getProperty(APPLICATION_VERSION) + "\n\n";
            help = help + "Command Line Arguments:\n";
            help = help + "-version\t\tPrints the Version of the program (e.g. 1.2.0)\n\n";
            help = help + "-versionNumber\t\tPrints the VersionNumber of the program (e.g. 120)\n\n";
            System.out.print(help);
            System.exit(0);
        }
    }

    protected void ensureSingleInstance(String lockFileDirectory, String lockFilename) {
        if (!ApplicationUtil.lockLockFile(lockFileDirectory, lockFilename)) {
            if (this.gui) {
                this.displayStartupError("Another Instance of the Application is running. Application is terminating.");
            } else {
                LoggerFactory.getLogger(this.mainClass).error("Another Instance of the Application is running. Application is terminating.");
            }
            System.exit(0);
        }
    }

    public void releaseSingleInstanceLockFile() {
        LoggerFactory.getLogger(this.getClass()).debug("Releasing Lockfile");
        ApplicationUtil.releaseLockFile();
    }

    protected void logStartupError(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace();
        ApplicationUtil.writeBasicErrorLogfile(Paths.get(this.applicationShortName + "-Error.log", new String[0]), message + ":\n" + ApplicationUtil.formatStackTrace(t));
    }

    protected void displayStartupError(String message) {
        JFrame frame = null;
        try {
            frame = ApplicationUtil.createInvisibleFrame(this.applicationShortName, this.applicationIcon);
            JOptionPane.showMessageDialog(frame, message, "Error", 0);
        }
        finally {
            if (frame != null) {
                frame.dispose();
            }
        }
    }

    protected void deleteOldLogFiles() {
        String logFilename = ApplicationProperties.getProperty(APPLICATION_SHORT_NAME) + ".log";
        ApplicationUtil.deleteOldLogFiles(7, logFilename, ApplicationProperties.getProperty(LOGS_PATH));
    }

    protected boolean setSystemLookAndFeel() {
        return this.changeLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    protected boolean changeLookAndFeel(String lookAndFeelClassName) {
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not set look and feel: {}", (Object)lookAndFeelClassName, (Object)e);
            return false;
        }
    }

    protected void addDefaultShutdownHook() {
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ApplicationMain.this.shutdownHookExit();
            }
        });
        shutdownThread.setName("Shutdown-Thread-" + shutdownThread.threadId());
        this.addShutdownHook(shutdownThread);
    }

    protected void shutdownHookExit() {
        this.exit();
    }

    protected void addShutdownHook(Thread shutdownHookThread) {
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        if (!this.shutdownHookThreads.contains(shutdownHookThread)) {
            this.shutdownHookThreads.add(shutdownHookThread);
        }
    }

    protected void removeShutdownHook(Thread shutdownHookThread) {
        Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        this.shutdownHookThreads.remove(shutdownHookThread);
    }

    protected void removeAllShutdownHooks() {
        for (Thread shutdownHookThread : this.shutdownHookThreads) {
            Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        }
        this.shutdownHookThreads.clear();
    }

    protected abstract void main(String[] var1);
}

