/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.application;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.exceptionhandler.SLF4JUncaughtExceptionHandler;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationUtil {
    private static final Pattern BIN_PATH_PATTERN = Pattern.compile("(?i)(.+?)[/\\\\]bin$");
    public static final DateTimeFormatter LOG_FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter BACKUP_FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd--HH-mm-ss-SSS");
    private static final DateTimeFormatter BASIC_ERROR_LOG_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static FileChannel lockFileChannel;
    private static FileLock lockFile;

    private ApplicationUtil() {
    }

    public static String getThisApplicationsPath(String jarFilename) {
        String classpath = System.getProperty("java.class.path");
        if (classpath.contains(";")) {
            String[] paths;
            for (String path : paths = classpath.split(";")) {
                Path f;
                Matcher m = BIN_PATH_PATTERN.matcher(path);
                if (!m.matches() || !Files.exists(f = Paths.get(m.replaceAll("$1"), new String[0]), new LinkOption[0])) continue;
                String rootPath = String.valueOf(f) + System.getProperty("file.separator");
                System.out.println("Rootpath of application detected: " + rootPath);
                return rootPath;
            }
        } else {
            Path f;
            Pattern p = Pattern.compile("(?i)(.+?)[/\\\\]" + jarFilename + "$");
            Matcher m = p.matcher(classpath);
            if (classpath.equalsIgnoreCase(jarFilename)) {
                return "./";
            }
            if (m.matches() && Files.exists(f = Paths.get(m.replaceAll("$1"), new String[0]), new LinkOption[0])) {
                String rootPath = String.valueOf(f) + System.getProperty("file.separator");
                System.out.println("Rootpath of application detected: " + rootPath);
                return rootPath;
            }
        }
        return "./";
    }

    public static String getThisApplicationsJarFilename(Class<?> classInJarFile) {
        try {
            Path jarFile = Paths.get(classInJarFile.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (Files.exists(jarFile, new LinkOption[0]) && Files.isRegularFile(jarFile, new LinkOption[0])) {
                System.out.println("Jar-Filename detected: " + String.valueOf(jarFile.getFileName()));
                return jarFile.getFileName().toString();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        System.err.println("Could not detect Jar-Filename");
        return "";
    }

    public static int compareVersions(String v1, String v2) {
        String[] strV1 = v1.split("\\.");
        String[] strV2 = v2.split("\\.");
        int diff = strV1.length - strV2.length;
        int len = strV1.length;
        if (diff < 0) {
            len = strV2.length;
        }
        int[] strV1C = new int[len];
        int[] strV2C = new int[len];
        try {
            int a;
            for (a = 0; a < len; ++a) {
                strV1C[a] = strV1.length <= a ? 0 : Integer.parseInt(strV1[a]);
            }
            for (a = 0; a < len; ++a) {
                strV2C[a] = strV2.length <= a ? 0 : Integer.parseInt(strV2[a]);
            }
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        for (int i = 0; i < len; ++i) {
            int comp = Integer.compare(strV1C[i], strV2C[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public static synchronized boolean lockLockFile(String strLockFilePath, String strLockFilename) {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        Path folder = Paths.get(strLockFilePath, new String[0]);
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Could not create directory: {}", (Object)folder);
            return false;
        }
        Path file = Paths.get(strLockFilePath, strLockFilename);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Could not create Lock-File: {}", (Object)file, (Object)e);
                return false;
            }
        }
        try {
            FileChannel channel;
            lockFileChannel = channel = FileChannel.open(file, StandardOpenOption.APPEND);
            lockFile = lockFileChannel.tryLock();
            if (lockFile == null) {
                logger.error("Could not lock Lock-File: {}", (Object)file);
                channel.close();
                lockFileChannel = null;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Could not lock Lock-File: {}", (Object)file, (Object)e);
            ApplicationUtil.closeLockFileChannel();
            return false;
        }
    }

    public static synchronized boolean releaseLockFile() {
        try {
            if (lockFile == null) {
                boolean bl = true;
                return bl;
            }
            lockFile.release();
            lockFile = null;
            boolean bl = true;
            return bl;
        }
        finally {
            ApplicationUtil.closeLockFileChannel();
        }
    }

    private static synchronized void closeLockFileChannel() {
        if (lockFileChannel != null) {
            try {
                lockFileChannel.close();
                lockFileChannel = null;
            }
            catch (IOException e) {
                Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
                logger.error("Could not close Lock-File channel", (Throwable)e);
            }
        }
    }

    public static synchronized FileLock getLockFile() {
        return lockFile;
    }

    public static void deleteOldLogFiles(int days, String logFileName, String logPath) {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        Path logDir = Paths.get(logPath, new String[0]);
        if (!Files.exists(logDir, new LinkOption[0]) || !Files.isDirectory(logDir, new LinkOption[0])) {
            return;
        }
        Pattern patternLogFiles = Pattern.compile(logFileName + "\\.(\\d{4}-\\d{2}-\\d{2})");
        LocalDate thresholdDate = LocalDate.now().minusDays(days);
        try (Stream<Path> stream = Files.list(logDir);){
            stream.filter(x -> patternLogFiles.matcher(x.getFileName().toString()).matches()).forEach(x -> ApplicationUtil.deleteOldLogFileIfNecessary(thresholdDate, patternLogFiles, x));
        }
        catch (IOException e) {
            logger.error("Could not delete old logfiles in folder: {}", (Object)logDir);
        }
    }

    private static void deleteOldLogFileIfNecessary(LocalDate thresholdDate, Pattern patternLogFiles, Path file) {
        try {
            Matcher matcher = patternLogFiles.matcher(file.getFileName().toString());
            String strDateOfFile = matcher.replaceAll("$1");
            LocalDate dateOfFile = LocalDate.parse(strDateOfFile, LOG_FILE_DATE_FORMAT);
            if (thresholdDate.isAfter(dateOfFile)) {
                Files.delete(file);
            }
        }
        catch (IOException | DateTimeParseException e) {
            Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
            logger.error("Could not check or delete Log-File: {}", (Object)file, (Object)e);
        }
    }

    public static void initializeSLF4JUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new SLF4JUncaughtExceptionHandler());
    }

    public static void logApplicationInfo() {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        logger.info("{} {}, Java-Version: {}, Java-Vendor: {}, OS: {} {} {}, Processors: {}, VM Max Memory: {}", new Object[]{ApplicationProperties.getProperty("ApplicationName"), ApplicationProperties.getProperty("ApplicationVersion"), System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().maxMemory()});
    }

    public static void writeBasicErrorLogfile(Path file, String errorMessage) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);){
            String dateTime = LocalDateTime.now().format(BASIC_ERROR_LOG_DATE_FORMAT);
            writer.write(dateTime + ": " + errorMessage);
            writer.flush();
        }
        catch (IOException e) {
            System.err.println("Could not write error log file: " + String.valueOf(file));
            e.printStackTrace();
        }
    }

    public static void deleteOldBackupFiles(Path folder, String filename, int daysToKeepBackup) {
        Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
        if (!Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
            return;
        }
        Pattern backupPattern = Pattern.compile("^" + filename + "-(\\d{4}-\\d{2}-\\d{2}--\\d{2}-\\d{2}-\\d{2}-\\d{3})$");
        LocalDateTime thresholdDateTime = LocalDateTime.now().minusDays(daysToKeepBackup);
        try (Stream<Path> stream = Files.list(folder);){
            stream.filter(x -> backupPattern.matcher(x.getFileName().toString()).matches()).forEach(x -> ApplicationUtil.deleteOldBackupFileIfNecessary(thresholdDateTime, backupPattern, x));
        }
        catch (IOException e) {
            logger.error("Could not delete old backup files in folder: {}", (Object)folder);
        }
    }

    private static void deleteOldBackupFileIfNecessary(LocalDateTime thresholdDateTime, Pattern backupPattern, Path file) {
        try {
            Matcher matcher = backupPattern.matcher(file.getFileName().toString());
            String strDateOfFile = matcher.replaceAll("$1");
            LocalDateTime dateTimeOfFile = LocalDateTime.parse(strDateOfFile, BACKUP_FILE_DATE_FORMAT);
            if (thresholdDateTime.isAfter(dateTimeOfFile)) {
                Files.delete(file);
            }
        }
        catch (IOException | DateTimeParseException e) {
            Logger logger = LoggerFactory.getLogger(ApplicationUtil.class);
            logger.error("Could not check or delete Backup-File: {}", (Object)file, (Object)e);
        }
    }

    public static JFrame createInvisibleFrame(String title) {
        return ApplicationUtil.createInvisibleFrame(title, null);
    }

    public static JFrame createInvisibleFrame(String title, Image icon) {
        JFrame frame = new JFrame(title);
        frame.setIconImage(icon);
        frame.setUndecorated(true);
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
        return frame;
    }

    public static String formatStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    static {
        lockFile = null;
    }
}

