/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.application.libraries;

import ch.supertomcat.supertomcatutils.application.libraries.LibraryInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibraryInfoUtil {
    private static final Pattern LIBRARY_NAME_PATTERN = Pattern.compile("(?i).+/(.+?)\\.jar!/META-INF/MANIFEST\\.MF$");
    private static List<LibraryInfo> libraries = null;

    private LibraryInfoUtil() {
    }

    public static synchronized List<LibraryInfo> getLibraries() {
        if (libraries == null) {
            LibraryInfoUtil.loadLibraries();
        }
        return libraries;
    }

    private static synchronized void loadLibraries() {
        InputStream in;
        URL url;
        Logger logger = LoggerFactory.getLogger(LibraryInfoUtil.class);
        ArrayList<LibraryInfo> libs = new ArrayList<LibraryInfo>();
        Properties thirdPartyLicenses = new Properties();
        try {
            Enumeration<URL> thirdPartyFiles = LibraryInfoUtil.class.getClassLoader().getResources("THIRD-PARTY.txt");
            while (thirdPartyFiles.hasMoreElements()) {
                url = thirdPartyFiles.nextElement();
                try {
                    in = url.openStream();
                    try {
                        thirdPartyLicenses.load(in);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Could not load THIRD-PARTY.txt from: {}", (Object)url, (Object)e);
                }
            }
        }
        catch (IOException e) {
            logger.error("Could not get THIRD-PARTY.txt list", (Throwable)e);
        }
        try {
            Enumeration<URL> manifestFiles = LibraryInfoUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifestFiles.hasMoreElements()) {
                url = manifestFiles.nextElement();
                Matcher matcher = LIBRARY_NAME_PATTERN.matcher(url.getPath());
                if (!matcher.matches()) {
                    logger.error("Could not get library name from path: {}", (Object)url.getPath());
                    continue;
                }
                String name = matcher.group(1);
                String version = "";
                Object license = thirdPartyLicenses.getProperty(name, "");
                try (InputStream inputStream = url.openStream();){
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    String implVersion = attributes.getValue("Implementation-Version");
                    String bundleVersion = attributes.getValue("Bundle-Version");
                    String bundleLicense = attributes.getValue("Bundle-License");
                    if (implVersion != null) {
                        version = implVersion;
                    } else if (bundleVersion != null) {
                        version = bundleVersion;
                    }
                    if (bundleLicense != null) {
                        license = ((String)license).isEmpty() ? bundleLicense : (String)license + "\n" + bundleLicense;
                    }
                }
                catch (IOException iOException) {
                    logger.error("Could not load manifest from: {}", (Object)url, (Object)iOException);
                }
                libs.add(new LibraryInfo(name, version, (String)license));
            }
        }
        catch (IOException e) {
            logger.error("Could not get MANIFEST.MF list", (Throwable)e);
        }
        try {
            Enumeration<URL> licensesPropFiles = LibraryInfoUtil.class.getClassLoader().getResources("Application_Library_Licenses.properties");
            while (licensesPropFiles.hasMoreElements()) {
                url = licensesPropFiles.nextElement();
                try {
                    in = url.openStream();
                    try {
                        Properties properties = new Properties();
                        properties.load(in);
                        HashSet<String> keys = new HashSet<String>();
                        for (Object object : properties.keySet()) {
                            String strKey = object.toString();
                            int pos = strKey.lastIndexOf(46);
                            if (pos <= 0) continue;
                            keys.add(strKey.substring(0, pos));
                        }
                        for (String string : keys) {
                            String name = properties.getProperty(string + ".name");
                            if (name == null) continue;
                            String version = properties.getProperty(string + ".version");
                            String license = properties.getProperty(string + ".license");
                            libs.add(new LibraryInfo(name, version != null ? version : "", license != null ? license : ""));
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Could not load Application_Library_Licenses.properties from: {}", (Object)url, (Object)e);
                }
            }
        }
        catch (IOException e) {
            logger.error("Could not get Application_Library_Licenses.properties list", (Throwable)e);
        }
        Collections.sort(libs);
        libraries = Collections.unmodifiableList(libs);
    }
}

