/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.database.sqlite;

import ch.supertomcat.supertomcatutils.application.ApplicationProperties;
import ch.supertomcat.supertomcatutils.application.ApplicationUtil;
import ch.supertomcat.supertomcatutils.gui.Localization;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLiteDB<T> {
    private static final String VACUUM_SQL_COMMAND = "VACUUM";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String databaseFile;
    protected final String tableName;

    public SQLiteDB(String databaseFile, String tableName, boolean backupDatabaseOnStart, boolean defragDatabaseOnStart, long defragMinFileSize) {
        File dbFile;
        this.databaseFile = databaseFile;
        this.tableName = tableName;
        this.createFolderIfNotExist();
        if (backupDatabaseOnStart) {
            this.backupDatabase();
        }
        boolean openDBFailed = false;
        try {
            Connection con = this.getDatabaseConnection();
            if (con != null) {
                con.close();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            openDBFailed = true;
            String databaseAbsolutePath = new File(databaseFile).getAbsolutePath();
            String dbError = String.format(Localization.getString("ErrorDBNotOpen"), databaseAbsolutePath);
            JOptionPane.showMessageDialog(null, dbError + "\n" + e.getMessage(), "Database-Error", 0);
            this.logger.error("Database could not be opened: {}", (Object)databaseAbsolutePath, (Object)e);
        }
        if (openDBFailed) {
            System.exit(0);
        }
        if (defragDatabaseOnStart && (dbFile = new File(databaseFile)).exists() && dbFile.length() >= defragMinFileSize) {
            this.defragDatabase();
        }
    }

    public String getDatabaseFile() {
        return this.databaseFile;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void createFolderIfNotExist() {
        Path folder = Paths.get(ApplicationProperties.getProperty("DatabasePath"), new String[0]);
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.error("Could not create database folder: {}", (Object)folder);
        }
    }

    private void backupDatabase() {
        String formattedDateTime = LocalDateTime.now().format(ApplicationUtil.BACKUP_FILE_DATE_FORMAT);
        String target = this.databaseFile + "-" + formattedDateTime;
        Path dbFile = Paths.get(this.databaseFile, new String[0]);
        String dbFilename = dbFile.getFileName().toString();
        if (Files.exists(dbFile, new LinkOption[0])) {
            CopyUtil.copy(this.databaseFile, target);
        }
        ApplicationUtil.deleteOldBackupFiles(Paths.get(ApplicationProperties.getProperty("DatabasePath"), new String[0]), dbFilename, 3);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean defragDatabase() {
        try (Connection con = this.getDatabaseConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = con.prepareStatement(VACUUM_SQL_COMMAND);
                try {
                    statement.executeUpdate();
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.error("Could not fragement database '{}'", (Object)this.databaseFile, (Object)e);
            return false;
        }
    }

    public void closeAllDatabaseConnections() {
    }

    protected Connection getDatabaseConnection() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        return DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile);
    }

    protected abstract boolean createDatabaseIfNotExist();

    protected abstract T convertResultSetToObject(ResultSet var1) throws SQLException, JAXBException;

    public abstract List<T> getAllEntries();

    public abstract T getEntry(int var1);

    public abstract boolean insertEntry(T var1);

    public abstract boolean insertEntries(List<T> var1);

    public abstract boolean updateEntry(T var1);

    public abstract boolean updateEntries(List<T> var1);

    public abstract boolean deleteEntry(T var1);

    public abstract boolean deleteEntries(List<T> var1);
}

