/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileExplorerUtil {
    private static Logger logger = LoggerFactory.getLogger(FileExplorerUtil.class);

    private FileExplorerUtil() {
    }

    public static void openDirectory(String dir) {
        FileExplorerUtil.openDirectory(Paths.get(dir, new String[0]));
    }

    public static void openDirectory(Path dir) {
        if (Desktop.isDesktopSupported()) {
            if (Files.exists(dir, new LinkOption[0])) {
                try {
                    Desktop.getDesktop().open(dir.toFile());
                }
                catch (IOException e) {
                    logger.error("Could not open directory: {}", (Object)dir, (Object)e);
                }
            }
        } else {
            logger.error("Could not open directory, because Desktop is not supported: {}", (Object)dir);
        }
    }

    public static void openEMail(String emailAddress) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.MAIL)) {
                try {
                    desktop.mail(new URI("mailto:" + emailAddress));
                }
                catch (IOException | URISyntaxException e) {
                    logger.error("Could not open email: {}", (Object)emailAddress, (Object)e);
                }
            }
        } else {
            logger.error("Could not open email, because Desktop is not supported: {}", (Object)emailAddress);
        }
    }

    public static void openURL(String url) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException ex) {
                logger.error("Could not open URL: {}", (Object)url, (Object)ex);
            }
        } else {
            logger.error("Could not open URL, because Desktop is not supported: {}", (Object)url);
        }
    }
}

