/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Localization {
    private static ResourceBundle msg;
    private static boolean notFoundPrefix;

    private Localization() {
    }

    public static void init(String baseName, String language, String country) {
        Localization.init(baseName, language, country, true);
    }

    public static void init(String baseName, String language, String country, boolean notFoundPrefix) {
        Locale currentLocale = Locale.of(language, country);
        msg = ResourceBundle.getBundle(baseName, currentLocale);
        Localization.notFoundPrefix = notFoundPrefix;
    }

    public static String getString(String key) {
        if (notFoundPrefix) {
            return Localization.getString(key, "NOSTRINGFOUND_");
        }
        return Localization.getString(key, "");
    }

    public static String getString(String key, String notFoundPrefix) {
        if (msg != null) {
            try {
                return msg.getString(key);
            }
            catch (MissingResourceException mre) {
                if (notFoundPrefix == null) {
                    return key;
                }
                return notFoundPrefix + key;
            }
        }
        if (notFoundPrefix == null) {
            return key;
        }
        return notFoundPrefix + key;
    }
}

