/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.dialog;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class FileDialogUtil {
    private FileDialogUtil() {
    }

    public static File showFolderOpenDialog(Component owner, String dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 1, false, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File showFolderOpenDialog(Component owner, File dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 1, false, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File showFolderSaveDialog(Component owner, String dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 1, true, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File showFolderSaveDialog(Component owner, File dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 1, true, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File[] showMultiFolderOpenDialog(Component owner, String dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 1, false, true);
    }

    public static File[] showMultiFolderOpenDialog(Component owner, File dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 1, false, true);
    }

    public static File[] showMultiFolderSaveDialog(Component owner, String dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 1, true, true);
    }

    public static File[] showMultiFolderSaveDialog(Component owner, File dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 1, true, true);
    }

    public static File showFileOpenDialog(Component owner, String dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 0, false, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File showFileOpenDialog(Component owner, File dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 0, false, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File showFileSaveDialog(Component owner, String dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 0, true, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File showFileSaveDialog(Component owner, File dir, FileFilter filter) {
        File[] files = FileDialogUtil.showFileDialog(owner, dir, filter, 0, true, false);
        return FileDialogUtil.getSingleSelectionResult(files);
    }

    public static File[] showMultiFileOpenDialog(Component owner, String dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 0, false, true);
    }

    public static File[] showMultiFileOpenDialog(Component owner, File dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 0, false, true);
    }

    public static File[] showMultiFileSaveDialog(Component owner, String dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 0, true, true);
    }

    public static File[] showMultiFileSaveDialog(Component owner, File dir, FileFilter filter) {
        return FileDialogUtil.showFileDialog(owner, dir, filter, 0, true, true);
    }

    public static File[] showFileDialog(Component owner, String dir, FileFilter filter, int fileSelectionMode, boolean save, boolean multi) {
        File startDir = null;
        if (dir != null && !dir.isEmpty()) {
            startDir = new File(dir);
        }
        return FileDialogUtil.showFileDialog(owner, startDir, filter, fileSelectionMode, save, multi);
    }

    public static File[] showFileDialog(Component owner, File dir, FileFilter filter, int fileSelectionMode, boolean save, boolean multi) {
        int retval;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(fileSelectionMode);
        if (multi) {
            fc.setMultiSelectionEnabled(true);
        }
        if (filter != null) {
            fc.setFileFilter(filter);
        }
        if (dir != null) {
            fc.setCurrentDirectory(dir);
        }
        if ((retval = save ? fc.showSaveDialog(owner) : fc.showOpenDialog(owner)) == 0) {
            if (multi) {
                return fc.getSelectedFiles();
            }
            return new File[]{fc.getSelectedFile()};
        }
        return null;
    }

    public static File getSingleSelectionResult(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }
}

