/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.dialog.about;

import ch.supertomcat.supertomcatutils.gui.Localization;
import ch.supertomcat.supertomcatutils.gui.formatter.UnitFormatUtil;
import java.awt.GridLayout;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class AboutDialogMemoryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JLabel lblMaxTotalMemory = new JLabel("");
    protected JProgressBar pgMemUsed = new JProgressBar();
    protected JProgressBar pgMemTotal = new JProgressBar();
    protected Timer timerMemory = null;

    public AboutDialogMemoryPanel() {
        this.setBorder(BorderFactory.createTitledBorder(Localization.getString("MemoryUsage")));
        this.setLayout(new GridLayout(3, 1));
        this.add(this.lblMaxTotalMemory);
        this.add(this.pgMemUsed);
        this.add(this.pgMemTotal);
        this.pgMemUsed.setStringPainted(true);
        this.pgMemTotal.setStringPainted(true);
        this.configureMemoryDisplayTimer();
        this.updateMemory();
    }

    protected void configureMemoryDisplayTimer() {
        this.timerMemory = new Timer(true);
        this.timerMemory.scheduleAtFixedRate((TimerTask)new MemoryUpdateTimerTask(), 0L, 2000L);
    }

    public void cancelUpdateTimer() {
        if (this.timerMemory != null) {
            this.timerMemory.cancel();
            this.timerMemory = null;
        }
    }

    protected synchronized void updateMemory() {
        long max = Runtime.getRuntime().maxMemory();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        int mode = 0;
        this.lblMaxTotalMemory.setText(Localization.getString("MaximumAvailableMemory") + ": " + UnitFormatUtil.getSizeString(max, mode));
        int val = (int)((double)used * 100.0 / (double)max);
        this.pgMemUsed.setMinimum(0);
        this.pgMemUsed.setMaximum(100);
        this.pgMemUsed.setValue(val);
        this.pgMemUsed.setString(Localization.getString("Used") + ": " + UnitFormatUtil.getSizeString(used, mode) + " / " + UnitFormatUtil.getSizeString(max, mode) + " (" + val + " %)");
        val = (int)((double)total * 100.0 / (double)max);
        this.pgMemTotal.setMinimum(0);
        this.pgMemTotal.setMaximum(100);
        this.pgMemTotal.setValue(val);
        this.pgMemTotal.setString(Localization.getString("CurrentlyAllocated") + ": " + UnitFormatUtil.getSizeString(total, mode) + " / " + UnitFormatUtil.getSizeString(max, mode) + " (" + val + " %)");
    }

    protected class MemoryUpdateTimerTask
    extends TimerTask {
        protected MemoryUpdateTimerTask() {
        }

        @Override
        public void run() {
            AboutDialogMemoryPanel.this.updateMemory();
        }
    }
}

