/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.list.renderer;

import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.filechooser.FileSystemView;

public class FileCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private boolean fullPathDisplay = false;

    public FileCellRenderer(boolean fullPathDisplay) {
        this.fullPathDisplay = fullPathDisplay;
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Path) {
            Path path = (Path)value;
            if (this.fullPathDisplay) {
                this.setText(path.toAbsolutePath().toString());
            } else {
                this.setText(path.getFileName().toString());
            }
            this.setIcon(FileSystemView.getFileSystemView().getSystemIcon(path.toFile()));
        } else if (value instanceof File) {
            File file = (File)value;
            if (this.fullPathDisplay) {
                this.setText(file.getAbsolutePath());
            } else {
                this.setText(file.getName());
            }
            this.setIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        return this;
    }
}

