/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.progress;

import ch.supertomcat.supertomcatutils.gui.progress.IProgressObserver;
import java.awt.EventQueue;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class ProgressWindow
extends JFrame
implements IProgressObserver {
    private static final long serialVersionUID = 1L;
    private JProgressBar pg = new JProgressBar();

    public ProgressWindow(String title, Window parent) {
        super(title);
        this.pg.setStringPainted(true);
        this.pg.setVisible(true);
        this.add(this.pg);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    @Override
    public void progressIncreased() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.pg.setValue(ProgressWindow.this.pg.getValue() + 1);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    @Override
    public void progressChanged(final int val) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.pg.setValue(val);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    @Override
    public void progressChanged(final int min, final int max, final int val) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.pg.setMinimum(min);
                ProgressWindow.this.pg.setMaximum(max);
                ProgressWindow.this.pg.setValue(val);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    @Override
    public void progressChanged(final String text) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.pg.setString(text);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    @Override
    public void progressChanged(final boolean visible) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.pg.setVisible(visible);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    @Override
    public void progressModeChanged(final boolean indeterminate) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.pg.setIndeterminate(indeterminate);
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }

    @Override
    public void progressCompleted() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.dispose();
            }
        };
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            EventQueue.invokeLater(task);
        }
    }
}

