/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.table;

import ch.supertomcat.supertomcatutils.gui.Localization;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableUtil {
    private static Logger logger = LoggerFactory.getLogger(TableUtil.class);

    private TableUtil() {
    }

    public static Map<String, Integer> parseColWidthsSetting(String setting) {
        if (setting == null || setting.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] columns = setting.split("\\|");
        if (columns == null || columns.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String col : columns) {
            if (col.isEmpty()) continue;
            String[] parts = col.split("=");
            if (parts == null || parts.length != 2) {
                logger.error("Could not parse column setting '{}' in setting String: {}", (Object)col, (Object)setting);
                continue;
            }
            String columnName = parts[0];
            String columnWidth = parts[1];
            try {
                int width = Integer.parseInt(columnWidth);
                map.put(columnName, width);
            }
            catch (NumberFormatException nfe) {
                logger.error("Could not parse column width '{}' for column name '{}' in setting String: {}", new Object[]{columnWidth, columnName, setting, nfe});
            }
        }
        return map;
    }

    public static String serializeColWidthSetting(Map<String, Integer> map) {
        if (map == null) {
            return "";
        }
        StringJoiner sj = new StringJoiner("|");
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            sj.add(entry.getKey() + "=" + String.valueOf(entry.getValue()));
        }
        return sj.toString();
    }

    public static String serializeColWidthSetting(JTable table) {
        StringJoiner sj = new StringJoiner("|");
        Enumeration<TableColumn> en = table.getColumnModel().getColumns();
        while (en.hasMoreElements()) {
            TableColumn col = en.nextElement();
            sj.add(String.valueOf(col.getIdentifier()) + "=" + col.getWidth());
        }
        return sj.toString();
    }

    public static void applyColWidths(JTable table, String setting) {
        TableUtil.applyColWidths(table, TableUtil.parseColWidthsSetting(setting));
    }

    public static void applyColWidths(JTable table, Map<String, Integer> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String columnName = entry.getKey();
            try {
                TableColumn col = table.getColumn(columnName);
                col.setPreferredWidth(entry.getValue());
                col.setWidth(entry.getValue());
            }
            catch (IllegalArgumentException e) {
                logger.error("Could not apply column widths for column: {}", (Object)columnName, (Object)e);
            }
        }
    }

    public static void internationalizeColumns(JTable table) {
        Enumeration<TableColumn> en = table.getColumnModel().getColumns();
        while (en.hasMoreElements()) {
            TableColumn col = en.nextElement();
            col.setIdentifier(col.getIdentifier());
            col.setHeaderValue(Localization.getString(col.getIdentifier().toString()));
        }
    }

    public static void applyTableSortOrder(JTable table, String setting) {
        TableUtil.applyTableSortOrder(table, TableUtil.parseColWidthsSetting(setting));
    }

    public static void applyTableSortOrder(JTable table, Map<String, Integer> map) {
        if (map == null) {
            return;
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String columnName = entry.getKey();
            int sortOrder = entry.getValue();
            if (sortOrder < 0 || sortOrder > 2) {
                logger.error("Could not apply sort order for column '{}', because value is invalid: {}", (Object)columnName, (Object)sortOrder);
                continue;
            }
            int columnIndex = table.getColumnModel().getColumnIndex(columnName);
            if (sortOrder == 1) {
                sortKeys.add(new RowSorter.SortKey(columnIndex, SortOrder.ASCENDING));
                continue;
            }
            if (sortOrder != 2) continue;
            sortKeys.add(new RowSorter.SortKey(columnIndex, SortOrder.DESCENDING));
        }
        if (!sortKeys.isEmpty()) {
            RowSorter<? extends TableModel> sorter = table.getRowSorter();
            if (sorter == null) {
                return;
            }
            sorter.setSortKeys(sortKeys);
            if (sorter instanceof DefaultRowSorter) {
                ((DefaultRowSorter)sorter).sort();
            }
        }
    }

    public static String serializeTableSortOrderSetting(JTable table) {
        RowSorter<? extends TableModel> sorter = table.getRowSorter();
        if (sorter == null) {
            return "";
        }
        StringJoiner sj = new StringJoiner("|");
        List<RowSorter.SortKey> sortKeys = sorter.getSortKeys();
        for (RowSorter.SortKey sortKey : sortKeys) {
            int columnIndex = sortKey.getColumn();
            TableColumn col = table.getColumnModel().getColumn(columnIndex);
            SortOrder so = sortKey.getSortOrder();
            int sortOrder = 0;
            if (so == SortOrder.ASCENDING) {
                sortOrder = 1;
            } else if (so == SortOrder.DESCENDING) {
                sortOrder = 2;
            }
            sj.add(String.valueOf(col.getIdentifier()) + "=" + sortOrder);
        }
        return sj.toString();
    }

    public static void setPreferredScrollableViewportWidth(JTable table, int characterCount) {
        FontMetrics fontMetrics = table.getFontMetrics(table.getFont());
        int charWidth = fontMetrics.charWidth('A');
        int preferredTableWidth = characterCount * charWidth;
        table.setPreferredScrollableViewportSize(new Dimension(preferredTableWidth, table.getPreferredScrollableViewportSize().height));
    }

    public static void setVisibleRowCount(JTable table, int rowCount) {
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredScrollableViewportSize().width, rowCount * table.getRowHeight()));
    }

    public static int calculateRowHeight(JTable table, boolean containsButtons, boolean includeTableFont) {
        ArrayList<Component> dummyComponents = new ArrayList<Component>();
        if (containsButtons) {
            dummyComponents.add(TableUtil.createDummyPanel(new JButton("Einstellungen")));
        }
        return TableUtil.calculateRowHeight(table, includeTableFont, dummyComponents);
    }

    public static int calculateRowHeight(JTable table, boolean includeTableFont, Component ... dummyComponents) {
        return TableUtil.calculateRowHeight(table, includeTableFont, Arrays.asList(dummyComponents));
    }

    public static int calculateRowHeight(JTable table, boolean includeTableFont, List<Component> dummyComponents) {
        int renderedComponentRowHeight = 0;
        for (Component comp : dummyComponents) {
            renderedComponentRowHeight = Integer.max(renderedComponentRowHeight, comp.getPreferredSize().height);
        }
        int fontRowHeight = 0;
        if (includeTableFont) {
            FontMetrics fontMetrics = table.getFontMetrics(table.getFont());
            fontRowHeight = fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        }
        int tableDefualtRowHeight = table.getRowHeight();
        return TableUtil.max(tableDefualtRowHeight, fontRowHeight, renderedComponentRowHeight);
    }

    private static JPanel createDummyPanel(Component dummyComp) {
        JPanel pnl = new JPanel();
        pnl.add(dummyComp);
        return pnl;
    }

    private static int max(int ... values) {
        int maxValue = 0;
        for (int value : values) {
            maxValue = Integer.max(value, maxValue);
        }
        return maxValue;
    }

    public static int calculateColumnHeaderWidth(JTable table, TableColumn column) {
        return TableUtil.calculateColumnHeaderWidth(table, column, 0);
    }

    public static int calculateColumnHeaderWidth(JTable table, TableColumn column, int additionalChars) {
        String headerValue = String.valueOf(column.getHeaderValue());
        FontMetrics fontMetrics = table.getFontMetrics(table.getFont());
        if (additionalChars <= 0) {
            return fontMetrics.stringWidth(headerValue);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headerValue);
        for (int i = 0; i < additionalChars; ++i) {
            sb.append("_");
        }
        return fontMetrics.stringWidth(sb.toString());
    }

    public static int[] convertRowIndexToModel(JTable table, int[] viewRows, boolean sort) {
        int[] convertedRows = new int[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            convertedRows[i] = table.convertRowIndexToModel(viewRows[i]);
        }
        if (sort) {
            Arrays.sort(convertedRows);
        }
        return convertedRows;
    }

    public static int[] convertRowIndexToView(JTable table, int[] modelRows, boolean sort) {
        int[] convertedRows = new int[modelRows.length];
        for (int i = 0; i < modelRows.length; ++i) {
            convertedRows[i] = table.convertRowIndexToView(modelRows[i]);
        }
        if (sort) {
            Arrays.sort(convertedRows);
        }
        return convertedRows;
    }

    public static int[] convertColumnIndexToModel(JTable table, int[] viewColumns, boolean sort) {
        int[] convertedColumns = new int[viewColumns.length];
        for (int i = 0; i < viewColumns.length; ++i) {
            convertedColumns[i] = table.convertColumnIndexToModel(viewColumns[i]);
        }
        if (sort) {
            Arrays.sort(convertedColumns);
        }
        return convertedColumns;
    }

    public static int[] convertColumnIndexToView(JTable table, int[] modelColumns, boolean sort) {
        int[] convertedColumns = new int[modelColumns.length];
        for (int i = 0; i < modelColumns.length; ++i) {
            convertedColumns[i] = table.convertColumnIndexToView(modelColumns[i]);
        }
        if (sort) {
            Arrays.sort(convertedColumns);
        }
        return convertedColumns;
    }
}

