/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.gui.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DefaultProgressBarColorRowRenderer
extends JProgressBar
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected final Color backgroundColor;
    protected final Color alternateBackgroundColor;
    protected final Color foregroundColor;
    protected final Color alternateForegroundColor;

    public DefaultProgressBarColorRowRenderer() {
        this(Color.WHITE, Color.decode("#F0F8FF"), null, null);
    }

    public DefaultProgressBarColorRowRenderer(Color backgroundColor, Color alternateBackgroundColor, Color foregroundColor, Color alternateForegroundColor) {
        this.backgroundColor = backgroundColor;
        this.alternateBackgroundColor = alternateBackgroundColor;
        this.foregroundColor = foregroundColor;
        this.alternateForegroundColor = alternateForegroundColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.prepareForegroundColor(this, table, value, isSelected, hasFocus, row, column);
        this.prepareBackgroundColor(this, table, value, isSelected, hasFocus, row, column);
        this.setOpaque(true);
        return this;
    }

    public void prepareBackgroundColor(Component comp, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color c = isSelected ? table.getSelectionBackground() : (row % 2 != 0 ? (this.alternateBackgroundColor != null ? this.alternateBackgroundColor : table.getBackground()) : (this.backgroundColor != null ? this.backgroundColor : table.getBackground()));
        comp.setBackground(c);
    }

    public void prepareForegroundColor(Component comp, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color c = isSelected ? table.getSelectionForeground() : (row % 2 != 0 ? (this.alternateForegroundColor != null ? this.alternateForegroundColor : table.getForeground()) : (this.foregroundColor != null ? this.foregroundColor : table.getForeground()));
        comp.setForeground(c);
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        String string = propertyName;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"orientation", "stringPainted", "string", "borderPainted", "indeterminate", "font", "foreground", String.class}, (Object)string2, n)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    super.firePropertyChange(propertyName, oldValue, newValue);
                    break block5;
                }
                case 5: 
                case 6: {
                    if (oldValue == newValue || this.getClientProperty("html") == null) break block5;
                    super.firePropertyChange(propertyName, oldValue, newValue);
                    break block5;
                }
                case 7: {
                    String str = string2;
                    if (!DefaultProgressBarColorRowRenderer.isScaleChanged(str, oldValue, newValue)) {
                        n = 8;
                        continue block5;
                    }
                    if (this.getClientProperty("html") == null) break block5;
                    super.firePropertyChange(propertyName, oldValue, newValue);
                    break block5;
                }
            }
            break;
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private static boolean isScaleChanged(String name, Object oldValue, Object newValue) {
        if (oldValue == newValue || !"graphicsConfiguration".equals(name)) {
            return false;
        }
        GraphicsConfiguration newGC = (GraphicsConfiguration)oldValue;
        GraphicsConfiguration oldGC = (GraphicsConfiguration)newValue;
        AffineTransform newTx = newGC != null ? newGC.getDefaultTransform() : null;
        AffineTransform oldTx = oldGC != null ? oldGC.getDefaultTransform() : null;
        return !Objects.equals(newTx, oldTx);
    }
}

