/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies;

import ch.supertomcat.supertomcatutils.http.HTTPUtil;
import ch.supertomcat.supertomcatutils.http.cookies.BrowserCookie;
import ch.supertomcat.supertomcatutils.http.cookies.CookieStrategy;
import ch.supertomcat.supertomcatutils.http.cookies.NoCookieStrategy;
import ch.supertomcat.supertomcatutils.http.cookies.firefox.FirefoxCookieStrategy;
import ch.supertomcat.supertomcatutils.http.cookies.ie.IECookieStrategy;
import ch.supertomcat.supertomcatutils.http.cookies.opera.newformat.OperaNewCookieStrategy;
import ch.supertomcat.supertomcatutils.http.cookies.opera.oldformat.OperaCookieStrategy;
import ch.supertomcat.supertomcatutils.http.cookies.palemoon.PaleMoonCookieStrategy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrowserCookies {
    public static final int BROWSER_NO_COOKIES = 0;
    public static final int BROWSER_IE = 1;
    public static final int BROWSER_FIREFOX = 2;
    public static final int BROWSER_OPERA = 3;
    public static final int BROWSER_PALE_MOON = 4;
    public static final int BROWSER_OPERA_NEW = 5;
    private static Logger logger = LoggerFactory.getLogger(BrowserCookies.class);
    private static final Map<Integer, CookieStrategy> cookieStrategies = new HashMap<Integer, CookieStrategy>();

    private BrowserCookies() {
    }

    public static void setCookieStrategy(int key, CookieStrategy cookieStrategy) {
        cookieStrategies.put(key, cookieStrategy);
    }

    public static CookieStrategy getCookieStrategy(int key) {
        return cookieStrategies.get(key);
    }

    public static Map<Integer, CookieStrategy> getCookieStrategies() {
        return new HashMap<Integer, CookieStrategy>(cookieStrategies);
    }

    public static String getCookies(String url, int browser) {
        return BrowserCookies.convertToString(BrowserCookies.getBrowserCookies(url, browser));
    }

    public static List<BrowserCookie> getBrowserCookies(String url, int browser) {
        if (!cookieStrategies.containsKey(browser)) {
            return new ArrayList<BrowserCookie>();
        }
        CookieStrategy cookieStrategy = cookieStrategies.get(browser);
        return BrowserCookies.getBrowserCookies(url, cookieStrategy);
    }

    public static String getCookies(String url, int browser, Map<String, String> cookieStrategyOptions) {
        return BrowserCookies.convertToString(BrowserCookies.getBrowserCookies(url, browser, cookieStrategyOptions));
    }

    public static List<BrowserCookie> getBrowserCookies(String url, int browser, Map<String, String> cookieStrategyOptions) {
        if (!cookieStrategies.containsKey(browser)) {
            return new ArrayList<BrowserCookie>();
        }
        CookieStrategy cookieStrategy = cookieStrategies.get(browser);
        return BrowserCookies.getBrowserCookies(url, cookieStrategy, cookieStrategyOptions);
    }

    public static String getCookies(String url, CookieStrategy cookieStrategy) {
        return BrowserCookies.convertToString(BrowserCookies.getBrowserCookies(url, cookieStrategy));
    }

    public static List<BrowserCookie> getBrowserCookies(String url, CookieStrategy cookieStrategy) {
        return BrowserCookies.getBrowserCookies(url, cookieStrategy, new HashMap<String, String>());
    }

    public static String getCookies(String url, CookieStrategy cookieStrategy, Map<String, String> cookieStrategyOptions) {
        return BrowserCookies.convertToString(BrowserCookies.getBrowserCookies(url, cookieStrategy, cookieStrategyOptions));
    }

    public static List<BrowserCookie> getBrowserCookies(String url, CookieStrategy cookieStrategy, Map<String, String> cookieStrategyOptions) {
        String path;
        URL completeURL;
        try {
            completeURL = HTTPUtil.parseURL(url);
        }
        catch (MalformedURLException mue) {
            return new ArrayList<BrowserCookie>();
        }
        String domain = completeURL.getHost();
        if (domain.startsWith("[") && domain.endsWith("]")) {
            domain = domain.substring(1, domain.length() - 1);
        }
        if ((path = completeURL.getPath()).isEmpty()) {
            path = "/";
        }
        String[] hostsArr = domain.split("\\.");
        String[] pathsArr = path.split("/");
        String[] hosts = new String[hostsArr.length - 1];
        for (int i = 0; i < hostsArr.length - 1; ++i) {
            hosts[i] = ".";
            for (int x = i; x < hostsArr.length; ++x) {
                int n = i;
                hosts[n] = hosts[n] + hostsArr[x];
                if (x >= hostsArr.length - 1) continue;
                int n2 = i;
                hosts[n2] = hosts[n2] + ".";
            }
        }
        String[] paths = new String[pathsArr.length > 0 ? pathsArr.length : 1];
        paths[0] = "/";
        for (int i = 1; i < pathsArr.length; ++i) {
            paths[i] = paths[i - 1] + (i == 1 ? "" : "/") + pathsArr[i];
        }
        List<BrowserCookie> cookies = cookieStrategy.getCookies(url, domain, hosts, paths, cookieStrategyOptions);
        if (logger.isDebugEnabled()) {
            logger.debug("Cookies for '{}': {}", (Object)domain, (Object)BrowserCookies.convertToString(cookies));
        }
        return cookies;
    }

    public static String convertToString(List<BrowserCookie> cookies) {
        StringJoiner sjCookies = new StringJoiner("; ");
        for (BrowserCookie cookie : cookies) {
            sjCookies.add(cookie.getName() + "=" + cookie.getValue());
        }
        return sjCookies.toString();
    }

    static {
        cookieStrategies.put(0, new NoCookieStrategy());
        cookieStrategies.put(1, new IECookieStrategy());
        cookieStrategies.put(2, new FirefoxCookieStrategy());
        cookieStrategies.put(3, new OperaCookieStrategy());
        cookieStrategies.put(4, new PaleMoonCookieStrategy());
        cookieStrategies.put(5, new OperaNewCookieStrategy());
    }
}

