/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.http.cookies.ie;

import ch.supertomcat.supertomcatutils.http.HTTPUtil;
import ch.supertomcat.supertomcatutils.http.cookies.BrowserCookie;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IECookies {
    private static final Pattern COOKIE_DOMAIN_PATTERN = Pattern.compile("^.*?@(.*?)\\[[0-9]+\\]\\.txt$");
    private static Logger logger = LoggerFactory.getLogger(IECookies.class);

    private IECookies() {
    }

    public static List<BrowserCookie> getCookiesFromIE(final String domain, final String[] hosts) {
        String os = System.getProperty("os.name").toLowerCase();
        if (!os.contains("windows")) {
            return new ArrayList<BrowserCookie>();
        }
        try {
            File folder = new File(System.getProperty("user.home"), "Cookies");
            if (folder.exists() && folder.isDirectory()) {
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.isFile()) {
                            String cookieDomain = COOKIE_DOMAIN_PATTERN.matcher(pathname.getName()).replaceAll("$1");
                            boolean matchedDomain = cookieDomain.equals(HTTPUtil.getTLDName(domain));
                            if (!matchedDomain) {
                                for (int i = 0; i < hosts.length && !(matchedDomain = cookieDomain.equals(HTTPUtil.getTLDName(hosts[i].substring(1)))); ++i) {
                                }
                            }
                            return matchedDomain;
                        }
                        return false;
                    }
                };
                ArrayList<BrowserCookie> allCookies = new ArrayList<BrowserCookie>();
                File[] files = folder.listFiles(filter);
                if (files != null) {
                    for (File file : files) {
                        List<BrowserCookie> cookies = IECookies.getCookiesFromIEFile(file, domain);
                        allCookies.addAll(cookies);
                    }
                }
                return allCookies;
            }
            return new ArrayList<BrowserCookie>();
        }
        catch (NullPointerException e) {
            logger.error("Could not read cookies from IE", (Throwable)e);
            return new ArrayList<BrowserCookie>();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<BrowserCookie> getCookiesFromIEFile(File f, String domain) {
        try (FileInputStream in = new FileInputStream(f);){
            ArrayList<BrowserCookie> arrayList;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, Charset.defaultCharset()));){
                ArrayList<BrowserCookie> cookies = new ArrayList<BrowserCookie>();
                BrowserCookie cookie = new BrowserCookie();
                cookie.setDomain("");
                int i = 0;
                String row = null;
                while ((row = br.readLine()) != null) {
                    if (row.equals("*")) {
                        i = 0;
                        if ((domain + "/").matches("^.*" + cookie.getDomain() + "$")) {
                            cookies.add(cookie);
                        }
                        cookie = new BrowserCookie();
                        cookie.setDomain("");
                        continue;
                    }
                    if (i > -1 && i < 8) {
                        switch (i) {
                            case 0: {
                                cookie.setName(row);
                                break;
                            }
                            case 1: {
                                cookie.setValue(row);
                                break;
                            }
                            case 2: {
                                cookie.setDomain(row);
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                cookie.setExpiryDate(null);
                                break;
                            }
                            case 5: {
                                cookie.setExpiryDate(null);
                                break;
                            }
                            case 6: {
                                cookie.setCreationDate(null);
                                break;
                            }
                            case 7: {
                                cookie.setCreationDate(null);
                                break;
                            }
                            default: {
                                logger.error("Unknown field position: {}", (Object)i);
                            }
                        }
                    }
                    ++i;
                }
                arrayList = cookies;
            }
            return arrayList;
        }
        catch (IOException e) {
            logger.error("Could not read cookies from IE: {}", (Object)f.getAbsolutePath(), (Object)e);
            return new ArrayList<BrowserCookie>();
        }
    }
}

