/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtil {
    private static Logger logger = LoggerFactory.getLogger(ZipUtil.class);

    private ZipUtil() {
    }

    public static void extractZipFile(Path zipFile, Path targetDirectory) throws IOException {
        logger.info("Extract zip file '{}' to: {}", (Object)zipFile, (Object)targetDirectory);
        try (InputStream in = Files.newInputStream(zipFile, new OpenOption[0]);
             ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry zipEntry;
            byte[] buffer = new byte[8192];
            while ((zipEntry = zis.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                Path outputPath = targetDirectory.resolve(entryName);
                logger.info("Zip Entry: Name: {}, Directory: {}, Size: {}", new Object[]{entryName, zipEntry.isDirectory(), zipEntry.getSize()});
                if (zipEntry.isDirectory()) {
                    logger.info("Create directory: {}", (Object)outputPath);
                    Files.createDirectories(outputPath, new FileAttribute[0]);
                } else {
                    logger.info("Extract file '{}' to: {}", (Object)entryName, (Object)outputPath);
                    try (OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);){
                        int read;
                        while ((read = zis.read(buffer)) != -1) {
                            out.write(buffer, 0, read);
                            out.flush();
                        }
                    }
                    try {
                        FileTime lastModifiedTime = zipEntry.getLastModifiedTime();
                        FileTime creationTime = zipEntry.getCreationTime();
                        BasicFileAttributeView attributes = Files.getFileAttributeView(outputPath, BasicFileAttributeView.class, new LinkOption[0]);
                        attributes.setTimes(lastModifiedTime, null, creationTime);
                    }
                    catch (IOException e) {
                        logger.error("Could not set file times for: {}", (Object)outputPath, (Object)e);
                    }
                }
                zis.closeEntry();
            }
        }
    }
}

