/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexReplace {
    protected Pattern pattern = null;
    protected String search = "";
    protected String replace = "";

    public RegexReplace() {
    }

    public RegexReplace(String search, String replace) throws PatternSyntaxException {
        this(search, replace, true);
    }

    public RegexReplace(String search, String replace, boolean compilePattern) throws PatternSyntaxException {
        if (search == null || replace == null) {
            throw new IllegalArgumentException("Search or replace was null: Search: " + search + ", Replace: " + replace);
        }
        this.setSearch(search, compilePattern);
        this.setReplace(replace);
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) throws PatternSyntaxException {
        this.setSearch(search, true);
    }

    public void setSearch(String search, boolean compilePattern) throws PatternSyntaxException {
        if (search == null) {
            throw new IllegalArgumentException("Search was null: Search: " + search);
        }
        this.pattern = compilePattern ? Pattern.compile(search) : null;
        this.search = search;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        if (replace == null) {
            throw new IllegalArgumentException("Replace was null: Replace: " + replace);
        }
        this.replace = replace;
    }

    protected boolean executionNeeded(String input) {
        return this.pattern != null && !this.search.isEmpty() && !input.isEmpty();
    }

    protected boolean executionNeeded(String input, int start) {
        return this.executionNeeded(input) && start >= 0 && start < input.length();
    }

    public int doSearch(String input, int start) {
        if (!this.executionNeeded(input, start)) {
            return -1;
        }
        Matcher matcher = this.pattern.matcher(input);
        if (matcher.find(start)) {
            return matcher.start();
        }
        return -1;
    }

    public String doReplace(String input) {
        if (!this.executionNeeded(input)) {
            return input;
        }
        return this.pattern.matcher(input).replaceAll(this.replace);
    }

    public String doReplaceMatchRegion(String input, int start) {
        if (!this.executionNeeded(input, start)) {
            return "";
        }
        Matcher matcher = this.pattern.matcher(input);
        if (matcher.find(start)) {
            Matcher regionMatcher = this.pattern.matcher(matcher.group());
            return regionMatcher.replaceAll(this.replace);
        }
        return "";
    }
}

