/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.regex;

import ch.supertomcat.supertomcatutils.regex.RegexReplace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexReplacePipeline {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String title;
    protected final List<RegexReplace> regexReplaces;

    public RegexReplacePipeline(String title) {
        this(title, new ArrayList<RegexReplace>());
    }

    public RegexReplacePipeline(String title, List<RegexReplace> regexReplaces) {
        this.title = title;
        this.regexReplaces = regexReplaces;
    }

    protected String doReplacement(String input, boolean undoWhenEmpty, String replacementType) {
        String result = input;
        for (int i = 0; i < this.regexReplaces.size(); ++i) {
            String beforeResult = result;
            result = this.regexReplaces.get(i).doReplace(result);
            this.logger.debug("{} -> Replace done -> Step {} -> Result: {}", new Object[]{beforeResult, i, result});
        }
        if (undoWhenEmpty && result.isEmpty()) {
            this.logger.debug("{} cannot be empty, so Replacement will be undone", (Object)replacementType);
            return input;
        }
        return result;
    }

    public String getReplacedPageTitle(String input) {
        return this.doReplacement(input, true, "Page-Title");
    }

    public String getReplacedFilename(String input) {
        return this.doReplacement(input, true, "Filename");
    }

    public List<RegexReplace> getRegexps() {
        return this.regexReplaces;
    }

    public RegexReplace getRegexp(int index) {
        return this.regexReplaces.get(index);
    }

    public void addRegExp(RegexReplace rre) {
        if (rre != null) {
            this.regexReplaces.add(rre);
        }
    }

    public void swapRegExp(int index1, int index2) {
        if (index1 == index2 || index1 < 0 || index1 >= this.regexReplaces.size() || index2 < 0 || index2 >= this.regexReplaces.size()) {
            return;
        }
        Collections.swap(this.regexReplaces, index1, index2);
    }

    public void removeRegExp(int index) {
        if (index >= 0 && index < this.regexReplaces.size()) {
            this.regexReplaces.remove(index);
        }
    }
}

