/*
 * Decompiled with CFR 0.152.
 */
package ch.supertomcat.supertomcatutils.settings;

import ch.supertomcat.supertomcatutils.application.ApplicationUtil;
import ch.supertomcat.supertomcatutils.io.CopyUtil;
import ch.supertomcat.supertomcatutils.settings.SettingsListener;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class SettingsManagerBase<T, L extends SettingsListener> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final JAXBContext jaxbContext;
    protected T settings = null;
    protected final Path settingsFolder;
    protected final Path settingsFile;
    protected final Path settingsBackupFile;
    protected final String defaultSettingsResourcePath;
    protected final String settingsSchemaResourcePath;
    protected List<L> listeners = new CopyOnWriteArrayList<L>();

    protected SettingsManagerBase(Class<?> objectFactoryClass, String defaultSettingsResourcePath, String settingsSchemaResourcePath) throws JAXBException {
        this.settingsFolder = null;
        this.settingsFile = null;
        this.settingsBackupFile = null;
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objectFactoryClass});
        this.defaultSettingsResourcePath = defaultSettingsResourcePath;
        this.settingsSchemaResourcePath = settingsSchemaResourcePath;
    }

    public SettingsManagerBase(String strSettingsFolder, String strSettingsFilename, Class<?> objectFactoryClass, String defaultSettingsResourcePath, String settingsSchemaResourcePath) throws JAXBException {
        this.settingsFolder = Paths.get(strSettingsFolder, new String[0]);
        this.settingsFile = this.settingsFolder.resolve(strSettingsFilename);
        this.settingsBackupFile = this.settingsFolder.resolve(strSettingsFilename + ".backup");
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objectFactoryClass});
        this.defaultSettingsResourcePath = defaultSettingsResourcePath;
        this.settingsSchemaResourcePath = settingsSchemaResourcePath;
        this.createDirectoryIfNotExists(this.settingsFolder);
        if (!Files.exists(this.settingsFile, new LinkOption[0])) {
            this.logger.info("Settingsfile not found in folder '{}': {}", (Object)this.settingsFolder, (Object)this.settingsFile);
            this.restoreSettingsFileFromBackupFile();
        } else {
            try {
                if (Files.size(this.settingsFile) == 0L) {
                    this.logger.error("Settingsfile is empty: {}", (Object)this.settingsFile);
                    this.restoreSettingsFileFromBackupFile();
                    return;
                }
            }
            catch (IOException e) {
                this.logger.error("Could not check file size of settings file: {}", (Object)this.settingsFile, (Object)e);
            }
            String formattedDateTime = LocalDateTime.now().format(ApplicationUtil.BACKUP_FILE_DATE_FORMAT);
            String target = this.settingsFile.toAbsolutePath().toString() + "-" + formattedDateTime;
            CopyUtil.copy(this.settingsFile.toAbsolutePath().toString(), target);
            ApplicationUtil.deleteOldBackupFiles(this.settingsFolder, strSettingsFilename, 3);
            if (!Files.exists(this.settingsBackupFile, new LinkOption[0])) {
                this.backupSettingsFile();
            }
        }
    }

    protected synchronized boolean restoreSettingsFileFromBackupFile() {
        try {
            if (Files.exists(this.settingsBackupFile, new LinkOption[0]) && Files.size(this.settingsBackupFile) > 0L) {
                this.logger.info("Restoring Settingsfile with backup: {}", (Object)this.settingsBackupFile);
                CopyUtil.copy(this.settingsBackupFile, this.settingsFile);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.logger.error("Could not restore settings file from backup", (Throwable)e);
            return false;
        }
    }

    protected synchronized boolean backupSettingsFile() {
        try {
            if (Files.exists(this.settingsFile, new LinkOption[0]) && Files.size(this.settingsFile) > 0L) {
                this.logger.debug("Backing up Settingsfile {} to {}", (Object)this.settingsFile, (Object)this.settingsBackupFile);
                CopyUtil.copy(this.settingsFile, this.settingsBackupFile);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.logger.error("Could not backup settings file", (Throwable)e);
            return false;
        }
    }

    protected boolean createDirectoryIfNotExists(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            this.logger.error("Settings-Folder could not be created: {}", (Object)directory, (Object)e);
            return false;
        }
    }

    protected synchronized T loadUserSettingsFile() throws IOException, SAXException, JAXBException {
        try (InputStream in = Files.newInputStream(this.settingsFile, new OpenOption[0]);){
            T t = this.loadSettingsFile(in, false);
            return t;
        }
    }

    protected synchronized T loadDefaultSettingsFile() throws IOException, SAXException, JAXBException {
        try (InputStream in = this.getClass().getResourceAsStream(this.defaultSettingsResourcePath);){
            if (in == null) {
                throw new IllegalArgumentException("Resource not found: " + this.defaultSettingsResourcePath);
            }
            T t = this.loadSettingsFile(in, true);
            return t;
        }
    }

    protected synchronized T loadSettingsFile(InputStream in, boolean validateSchema) throws SAXException, JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        if (validateSchema) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource(this.settingsSchemaResourcePath));
            unmarshaller.setSchema(schema);
        }
        return (T)unmarshaller.unmarshal(in);
    }

    protected synchronized void writeSettingsFile(T settings, OutputStream out, boolean validateSchema) throws SAXException, JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (validateSchema) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource(this.settingsSchemaResourcePath));
            marshaller.setSchema(schema);
        }
        marshaller.marshal(settings, out);
    }

    protected void settingsChanged() {
        for (SettingsListener listener : this.listeners) {
            listener.settingsChanged();
        }
    }

    public void addSettingsListener(L l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeSettingsListener(L l) {
        this.listeners.remove(l);
    }

    public T getSettings() {
        return this.settings;
    }
}

