/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.dao;

import com.github.bingoohuang.blackcat.server.dao.ConfigDao;
import com.google.common.collect.ConcurrentHashMultiset;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BlackcatConfig {
    @Autowired
    ConfigDao configDao;

    @Bean
    public List<ConfigMetric> configMetrics() {
        return this.configDao.queryConfigMetrics();
    }

    @Bean
    public List<ConfigProcess> configProcesses() {
        return this.configDao.queryConfigProcess();
    }

    @Bean
    public ConfigThreshold configThreshold() {
        return this.configDao.queryConfigThreshold();
    }

    @Bean
    public List<String> methodPkgPrefixes() {
        return this.configDao.queryMethodPackagePrefixTopn();
    }

    @Bean
    public ConcurrentHashMultiset<String> times() {
        return ConcurrentHashMultiset.create();
    }

    @Bean
    public ConcurrentHashMap<String, Long> beats() {
        return new ConcurrentHashMap<String, Long>();
    }

    @Bean
    public List<String> configHostnames() {
        return this.configDao.queryHostnames();
    }

    public static class ConfigThreshold {
        int availMemoryLowRatio;
        long availMemoryLowSize;
        int loadOverRatio;
        int availDiskLowRatio;
        long availDiskLowSize;
        long methodMaxMillis;

        public int getAvailMemoryLowRatio() {
            return this.availMemoryLowRatio;
        }

        public long getAvailMemoryLowSize() {
            return this.availMemoryLowSize;
        }

        public int getLoadOverRatio() {
            return this.loadOverRatio;
        }

        public int getAvailDiskLowRatio() {
            return this.availDiskLowRatio;
        }

        public long getAvailDiskLowSize() {
            return this.availDiskLowSize;
        }

        public long getMethodMaxMillis() {
            return this.methodMaxMillis;
        }

        public void setAvailMemoryLowRatio(int availMemoryLowRatio) {
            this.availMemoryLowRatio = availMemoryLowRatio;
        }

        public void setAvailMemoryLowSize(long availMemoryLowSize) {
            this.availMemoryLowSize = availMemoryLowSize;
        }

        public void setLoadOverRatio(int loadOverRatio) {
            this.loadOverRatio = loadOverRatio;
        }

        public void setAvailDiskLowRatio(int availDiskLowRatio) {
            this.availDiskLowRatio = availDiskLowRatio;
        }

        public void setAvailDiskLowSize(long availDiskLowSize) {
            this.availDiskLowSize = availDiskLowSize;
        }

        public void setMethodMaxMillis(long methodMaxMillis) {
            this.methodMaxMillis = methodMaxMillis;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigThreshold)) {
                return false;
            }
            ConfigThreshold other = (ConfigThreshold)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAvailMemoryLowRatio() != other.getAvailMemoryLowRatio()) {
                return false;
            }
            if (this.getAvailMemoryLowSize() != other.getAvailMemoryLowSize()) {
                return false;
            }
            if (this.getLoadOverRatio() != other.getLoadOverRatio()) {
                return false;
            }
            if (this.getAvailDiskLowRatio() != other.getAvailDiskLowRatio()) {
                return false;
            }
            if (this.getAvailDiskLowSize() != other.getAvailDiskLowSize()) {
                return false;
            }
            return this.getMethodMaxMillis() == other.getMethodMaxMillis();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigThreshold;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAvailMemoryLowRatio();
            long $availMemoryLowSize = this.getAvailMemoryLowSize();
            result = result * 59 + (int)($availMemoryLowSize >>> 32 ^ $availMemoryLowSize);
            result = result * 59 + this.getLoadOverRatio();
            result = result * 59 + this.getAvailDiskLowRatio();
            long $availDiskLowSize = this.getAvailDiskLowSize();
            result = result * 59 + (int)($availDiskLowSize >>> 32 ^ $availDiskLowSize);
            long $methodMaxMillis = this.getMethodMaxMillis();
            result = result * 59 + (int)($methodMaxMillis >>> 32 ^ $methodMaxMillis);
            return result;
        }

        public String toString() {
            return "BlackcatConfig.ConfigThreshold(availMemoryLowRatio=" + this.getAvailMemoryLowRatio() + ", availMemoryLowSize=" + this.getAvailMemoryLowSize() + ", loadOverRatio=" + this.getLoadOverRatio() + ", availDiskLowRatio=" + this.getAvailDiskLowRatio() + ", availDiskLowSize=" + this.getAvailDiskLowSize() + ", methodMaxMillis=" + this.getMethodMaxMillis() + ")";
        }
    }

    public static class ConfigProcess {
        String processName;
        List<String> hostnames;
        List<String> argKeys;

        public String getProcessName() {
            return this.processName;
        }

        public List<String> getHostnames() {
            return this.hostnames;
        }

        public List<String> getArgKeys() {
            return this.argKeys;
        }

        public void setProcessName(String processName) {
            this.processName = processName;
        }

        public void setHostnames(List<String> hostnames) {
            this.hostnames = hostnames;
        }

        public void setArgKeys(List<String> argKeys) {
            this.argKeys = argKeys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigProcess)) {
                return false;
            }
            ConfigProcess other = (ConfigProcess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$processName = this.getProcessName();
            String other$processName = other.getProcessName();
            if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
                return false;
            }
            List<String> this$hostnames = this.getHostnames();
            List<String> other$hostnames = other.getHostnames();
            if (this$hostnames == null ? other$hostnames != null : !((Object)this$hostnames).equals(other$hostnames)) {
                return false;
            }
            List<String> this$argKeys = this.getArgKeys();
            List<String> other$argKeys = other.getArgKeys();
            return !(this$argKeys == null ? other$argKeys != null : !((Object)this$argKeys).equals(other$argKeys));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigProcess;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $processName = this.getProcessName();
            result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
            List<String> $hostnames = this.getHostnames();
            result = result * 59 + ($hostnames == null ? 43 : ((Object)$hostnames).hashCode());
            List<String> $argKeys = this.getArgKeys();
            result = result * 59 + ($argKeys == null ? 43 : ((Object)$argKeys).hashCode());
            return result;
        }

        public String toString() {
            return "BlackcatConfig.ConfigProcess(processName=" + this.getProcessName() + ", hostnames=" + this.getHostnames() + ", argKeys=" + this.getArgKeys() + ")";
        }
    }

    public static class ConfigMetric {
        private String name;
        private long divbase;

        public String getName() {
            return this.name;
        }

        public long getDivbase() {
            return this.divbase;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDivbase(long divbase) {
            this.divbase = divbase;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigMetric)) {
                return false;
            }
            ConfigMetric other = (ConfigMetric)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getDivbase() == other.getDivbase();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigMetric;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $divbase = this.getDivbase();
            result = result * 59 + (int)($divbase >>> 32 ^ $divbase);
            return result;
        }

        public String toString() {
            return "BlackcatConfig.ConfigMetric(name=" + this.getName() + ", divbase=" + this.getDivbase() + ")";
        }
    }
}

