/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.dao;

import com.github.bingoohuang.blackcat.server.domain.BlackcatEventLast;
import com.github.bingoohuang.blackcat.server.domain.BlackcatFileStoresReq;
import com.github.bingoohuang.blackcat.server.domain.BlackcatLoadReq;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMemoryReq;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMethodRuntimeReq;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMetricReq;
import com.github.bingoohuang.blackcat.server.domain.BlackcatProcessReq;
import com.github.bingoohuang.blackcat.server.domain.BlackcatTraceReq;
import com.github.bingoohuang.cqler.annotations.Cql;
import com.github.bingoohuang.cqler.annotations.Cqler;

@Cqler(keyspace="blackcat")
public interface EventDao {
    @Cql(value="INSERT INTO event_memory(hostname,          ts,          total,          available) VALUES (            #hostname#, #timestamp#, #memory.total#, #memory.available#)")
    public void addMemoryEvent(BlackcatMemoryReq var1);

    @Cql(value="INSERT INTO event_stores(hostname,          ts,   names,   descriptions,   totals,   usables) VALUES (   #hostname#, #timestamp#, #names#, #descriptions#, #totals#, #usables#)")
    public void addFileStoresEvent(BlackcatFileStoresReq var1);

    @Cql(value="INSERT INTO event_load(hostname,          ts,        cpuNum,        oneMinAvg,        fiveMinsAvg,        fifteenMinsAvg) VALUES (          #hostname#, #timestamp#, #load.cpuNum#, #load.oneMinAvg#, #load.fiveMinsAvg#, #load.fifteenMinsAvg#)")
    public void addLoadEvent(BlackcatLoadReq var1);

    @Cql(value="INSERT INTO event_process(hostname,          ts,   args,   pids,   reses,   startTimes,   names) VALUES (             #hostname#, #timestamp#, #args#, #pids#, #reses#, #startTimes#, #names#)")
    public void addProcessesEvent(BlackcatProcessReq var1);

    @Cql(value="UPDATE event_last SET last_ts = #lastTs# WHERE hostname = #hostname# AND event_type = #eventType#")
    public void updateEventLast(BlackcatEventLast var1);

    @Cql(value="INSERT INTO event_method_runtime(invokeId,   hostname,          ts,      className,      methodName,      methodDesc,      startMillis,      endMillis,      costNano,      args,      pid,      executionId,      result,      throwableCaught,      throwableUncaught,      sameThrowable) VALUES(                  #rt.invokeId#, #hostname#, #timestamp#, #rt.className#, #rt.methodName#, #rt.methodDesc#, #rt.startMillis#, #rt.endMillis#, #rt.costNano#, #rt.args#, #rt.pid#, #rt.executionId#, #rt.result#, #rt.throwableCaught#, #rt.throwableUncaught#, #rt.sameThrowable#)")
    public void addMethodRuntime(BlackcatMethodRuntimeReq var1);

    @Cql(value="INSERT INTO event_trace(traceId, linkId, ts, tsPretty, hostname, msgType, msg) VALUES(#traceId#, #linkId#, #ts#, #tsPretty#, #hostname#, #msgType#, #msg#)")
    public void updateEventTrace(BlackcatTraceReq var1);

    @Cql(value="UPDATE event_metric SET val = val + #val# WHERE name = #name# AND   day  = #day# AND   seq  = #seq# ")
    public void addEventMetric(BlackcatMetricReq var1);
}

