/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.sdk.utils.Blackcats;
import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.dao.BlackcatConfig;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMethodRuntimeReq;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.eventbus.Subscribe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BlackcatMethodRuntimeReqListener
implements BlackcatReqListener {
    private static final Logger log = LoggerFactory.getLogger(BlackcatMethodRuntimeReqListener.class);
    @Autowired
    MsgService msgService;
    @Autowired
    EventDao eventDao;
    @Autowired
    @Qualifier(value="times")
    ConcurrentHashMultiset<String> times;
    @Autowired
    BlackcatConfig.ConfigThreshold configThreshold;
    static Pattern classMethod = Pattern.compile("(?<=\\.)(\\w+\\.\\w+)(?=\\()");

    @Subscribe
    public void deal(BlackcatMethodRuntimeReq req) {
        try {
            String hostname = req.getHostname();
            this.times.add((Object)(hostname + "-MethodRuntime-times"));
            this.tryAlert(req);
            this.eventDao.addMethodRuntime(req);
        }
        catch (Exception e) {
            log.error("deal BlackcatMethodRuntimeReq error", (Throwable)e);
        }
    }

    private void tryAlert(BlackcatMethodRuntimeReq req) {
        boolean hasAlert;
        long methodMaxMillis = this.configThreshold.getMethodMaxMillis();
        boolean bl = hasAlert = req.getRt().getCostNano() > methodMaxMillis * 1000000L;
        if (!hasAlert) {
            return;
        }
        StrBuilder alert = StrBuilder.str((char)'\n').p(req.getHostname());
        alert.p('\n').p(req.rt.getClassName());
        alert.p('\n').p(BlackcatMethodRuntimeReqListener.simpleMethodName(req.rt.getMethodDesc()));
        String cost = Blackcats.decimal((double)((double)req.rt.getCostNano() / 1000000.0)) + "ms";
        this.times.add((Object)(req.getHostname() + "-MethodRuntime-alerts"));
        this.msgService.sendMsg("\u65b9\u6cd5\u8017\u65f6" + cost, alert.toString());
    }

    private static String simpleMethodName(String source) {
        Matcher matcher = classMethod.matcher(source);
        matcher.find();
        return matcher.group();
    }
}

