/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.dao.BlackcatConfig;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventLast;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventType;
import com.github.bingoohuang.blackcat.server.domain.BlackcatProcessReq;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BlackcatProcessReqListener
implements BlackcatReqListener {
    @Autowired
    @Qualifier(value="configProcesses")
    List<BlackcatConfig.ConfigProcess> configProcesses;
    @Autowired
    MsgService msgService;
    @Autowired
    EventDao eventDao;
    @Autowired
    @Qualifier(value="times")
    ConcurrentHashMultiset<String> times;
    @Autowired
    @Qualifier(value="beats")
    ConcurrentHashMap<String, Long> beats;

    @Subscribe
    public void deal(BlackcatProcessReq req) {
        String hostname = req.getHostname();
        this.times.add((Object)(hostname + "-Process-times"));
        this.beats.put(hostname, System.currentTimeMillis());
        this.tryAlert(req);
        this.eventDao.updateEventLast(new BlackcatEventLast(hostname, BlackcatEventType.Process.toString(), req.getTimestamp()));
        this.eventDao.addProcessesEvent(req);
    }

    private void tryAlert(BlackcatProcessReq req) {
        boolean hasAlert = false;
        StrBuilder alert = StrBuilder.str((char)'\n').p(req.getHostname());
        for (BlackcatConfig.ConfigProcess confProcess : this.configProcesses) {
            List<String> hostnames = confProcess.getHostnames();
            if (!hostnames.contains(req.getHostname())) continue;
            String processName = confProcess.getProcessName();
            if (req.getNames().contains(processName)) continue;
            hasAlert = true;
            alert.p("\u8fdb\u7a0b").p(processName).p("\u4e0d\u5b58\u5728").p('\n');
        }
        if (!hasAlert) {
            return;
        }
        this.times.add((Object)(req.getHostname() + "-Process-alerts"));
        this.msgService.sendMsg("\u8fdb\u7a0b\u544a\u8b66", alert.toString());
    }
}

