/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.handler;

import com.github.bingoohuang.blackcat.sdk.BlackcatMsgHandler;
import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.sdk.utils.Blackcats;
import com.github.bingoohuang.blackcat.server.base.BlackcatEventReq;
import com.github.bingoohuang.blackcat.server.base.BlackcatJob;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.QuartzScheduler;
import com.github.bingoohuang.blackcat.server.dao.BlackcatConfig;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMemoryReq;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.EventBus;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class CassandraMsgHandler
implements BlackcatMsgHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CassandraMsgHandler.class);
    @Autowired
    QuartzScheduler scheduler;
    @Autowired
    @Qualifier(value="configProcesses")
    List<BlackcatConfig.ConfigProcess> configProcs;
    EventBus reqEventBus = new EventBus();
    private ApplicationContext appContext;
    Cache<String, ChannelHandlerContext> ctxCache = CacheBuilder.newBuilder().weakValues().build();
    AttributeKey<String> channelHostname = AttributeKey.valueOf((String)"channelHostname");

    public void scheduleJob() {
        Map reqListeners = this.appContext.getBeansOfType(BlackcatJob.class);
        for (BlackcatJob job : reqListeners.values()) {
            job.scheduleJob(this.scheduler);
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.registerToEventBus();
        this.scheduleJob();
    }

    private void registerToEventBus() {
        Map reqListeners = this.appContext.getBeansOfType(BlackcatReqListener.class);
        for (Object subscriber : reqListeners.values()) {
            this.reqEventBus.register(subscriber);
        }
    }

    public void handle(BlackcatMsg.BlackcatReq req, ChannelHandlerContext ctx) {
        try {
            BlackcatEventReq eventReq = this.process(req);
            this.sendConfigToAgent(eventReq, req, ctx);
        }
        catch (Exception e) {
            log.warn("error", (Throwable)e);
        }
    }

    private void sendConfigToAgent(BlackcatEventReq eventReq, BlackcatMsg.BlackcatReq req, ChannelHandlerContext ctx) {
        if (eventReq == null || !eventReq.isFromBlackcatAgent()) {
            return;
        }
        String hostname = req.getBlackcatReqHead().getHostname();
        ChannelHandlerContext present = (ChannelHandlerContext)this.ctxCache.getIfPresent((Object)hostname);
        if (present == null) {
            this.ctxCache.put((Object)hostname, (Object)ctx);
            Attribute attr = ctx.attr(this.channelHostname);
            attr.set((Object)hostname);
            ctx.write((Object)this.createConfigRsp(hostname));
        }
    }

    private BlackcatMsg.BlackcatRsp createConfigRsp(String hostname) {
        BlackcatMsg.BlackcatWarnConfig.Builder builder = BlackcatMsg.BlackcatWarnConfig.newBuilder();
        for (BlackcatConfig.ConfigProcess configProcess : this.configProcs) {
            if (!configProcess.getHostnames().contains(hostname)) continue;
            BlackcatMsg.BlackcatWarnConfig.BlackcatWarnProcess warnProcess = BlackcatMsg.BlackcatWarnConfig.BlackcatWarnProcess.newBuilder().setProcessName(configProcess.getProcessName()).addAllProcessKeys(configProcess.getArgKeys()).build();
            builder.addBlackcatWarnProcess(warnProcess);
        }
        return BlackcatMsg.BlackcatRsp.newBuilder().setBlackcatRspHead(BlackcatMsg.BlackcatRspHead.newBuilder().setRspType(BlackcatMsg.BlackcatRspHead.RspType.BlackcatWarnConfig)).setBlackcatWarnConfig(builder).build();
    }

    private BlackcatEventReq process(BlackcatMsg.BlackcatReq req) throws Exception {
        String packageName = BlackcatMemoryReq.class.getPackage().getName();
        Object instance = Blackcats.parseReq((String)packageName, (BlackcatMsg.BlackcatReq)req);
        if (instance != null) {
            this.reqEventBus.post(instance);
        }
        return (BlackcatEventReq)instance;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }
}

