/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.domain;

import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.server.base.BlackcatEventReq;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;

public class BlackcatFileStoresReq
implements BlackcatEventReq {
    private final String hostname;
    private final long timestamp;
    private final List<String> names;
    private final List<String> descriptions;
    private final List<Long> totals;
    private final List<Long> usables;

    public BlackcatFileStoresReq(BlackcatMsg.BlackcatReqHead head, BlackcatMsg.BlackcatFileStores stores) {
        this.hostname = head.getHostname();
        this.timestamp = head.getTimestamp();
        List fileStores = stores.getFileStoreList();
        this.names = Lists.transform((List)fileStores, (Function)new Function<BlackcatMsg.BlackcatFileStores.FileStore, String>(){

            public String apply(BlackcatMsg.BlackcatFileStores.FileStore f) {
                return f.getName();
            }
        });
        this.descriptions = Lists.transform((List)fileStores, (Function)new Function<BlackcatMsg.BlackcatFileStores.FileStore, String>(){

            public String apply(BlackcatMsg.BlackcatFileStores.FileStore f) {
                return f.getDescription();
            }
        });
        this.totals = Lists.transform((List)fileStores, (Function)new Function<BlackcatMsg.BlackcatFileStores.FileStore, Long>(){

            public Long apply(BlackcatMsg.BlackcatFileStores.FileStore f) {
                return f.getTotal();
            }
        });
        this.usables = Lists.transform((List)fileStores, (Function)new Function<BlackcatMsg.BlackcatFileStores.FileStore, Long>(){

            public Long apply(BlackcatMsg.BlackcatFileStores.FileStore f) {
                return f.getUsable();
            }
        });
    }

    @Override
    public boolean isFromBlackcatAgent() {
        return true;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public List<Long> getTotals() {
        return this.totals;
    }

    public List<Long> getUsables() {
        return this.usables;
    }
}

