/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.sdk.utils.Blackcats;
import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventLast;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventType;
import com.github.bingoohuang.blackcat.server.domain.BlackcatFileStoresReq;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackcatFileStoresReqListener
implements BlackcatReqListener {
    @Autowired
    MsgService msgService;
    @Autowired
    EventDao eventDao;
    @Autowired
    BlackcatConfigBean bean;

    @Subscribe
    public void deal(BlackcatFileStoresReq req) {
        String hostname = req.getHostname();
        this.bean.getTimes().add((Object)(hostname + "-FileStores-times"));
        this.bean.getBeats().put(hostname, System.currentTimeMillis());
        this.tryAlert(req);
        this.eventDao.updateEventLast(new BlackcatEventLast(hostname, BlackcatEventType.FileStore.toString(), req.getTimestamp()));
        this.eventDao.addFileStoresEvent(req);
    }

    private void tryAlert(BlackcatFileStoresReq req) {
        long configLowSize = this.bean.getConfigThreshold().getAvailDiskLowSize();
        int configLowRatio = this.bean.getConfigThreshold().getAvailDiskLowRatio();
        StrBuilder alert = StrBuilder.str((char)'\n').p(req.getHostname());
        boolean hasAlert = false;
        int ii = req.getNames().size();
        for (int i = 0; i < ii; ++i) {
            boolean isLowRatio;
            String fileStoreName = req.getNames().get(i);
            if ("tmpfs".equals(fileStoreName)) continue;
            Long avail = req.getUsables().get(i);
            boolean isLowSize = avail < configLowSize;
            long ratio = avail * 100L / req.getTotals().get(i);
            boolean bl = isLowRatio = ratio < (long)configLowRatio;
            if (!isLowSize && !isLowRatio) continue;
            hasAlert = true;
            alert.p('\n').p(fileStoreName).p("\u53ef\u7528").p(Blackcats.prettyBytes((long)avail));
            if (isLowSize) {
                alert.p(", \u4f4e\u4e8e\u9600\u503c").p(Blackcats.prettyBytes((long)configLowSize));
            }
            if (!isLowRatio) continue;
            alert.p(", \u4f4e\u4e8e\u6bd4\u4f8b").p(ratio).p('%');
        }
        if (!hasAlert) {
            return;
        }
        this.bean.getTimes().add((Object)(req.getHostname() + "-FileStores-alerts"));
        this.msgService.sendMsg("\u78c1\u76d8\u544a\u8b66", alert.toString());
    }
}

