/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.sdk.utils.Blackcats;
import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventLast;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventType;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMemoryReq;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackcatMemoryReqListener
implements BlackcatReqListener {
    @Autowired
    MsgService msgService;
    @Autowired
    EventDao eventDao;
    @Autowired
    BlackcatConfigBean bean;

    @Subscribe
    public void deal(BlackcatMemoryReq req) {
        String hostname = req.getHostname();
        this.bean.getTimes().add((Object)(hostname + "-Memory-times"));
        this.bean.getBeats().put(hostname, System.currentTimeMillis());
        this.tryAlert(req);
        this.eventDao.updateEventLast(new BlackcatEventLast(hostname, BlackcatEventType.Memory.toString(), req.getTimestamp()));
        this.eventDao.addMemoryEvent(req);
    }

    private void tryAlert(BlackcatMemoryReq req) {
        long configLowSize;
        long avail = req.getMemory().getAvailable();
        if (avail >= (configLowSize = this.bean.getConfigThreshold().getAvailMemoryLowSize())) {
            return;
        }
        StrBuilder alert = StrBuilder.str((char)'\n').p(req.getHostname());
        alert.p("\u53ef\u7528\u5185\u5b58").p(Blackcats.prettyBytes((long)avail));
        alert.p(", \u4f4e\u4e8e\u9600\u503c").p(Blackcats.prettyBytes((long)configLowSize));
        this.bean.getTimes().add((Object)(req.getHostname() + "-Memory-alerts"));
        this.msgService.sendMsg("\u5185\u5b58\u544a\u8b66", alert.toString());
    }
}

