/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.sdk.utils.Blackcats;
import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import com.github.bingoohuang.blackcat.server.domain.BlackcatMethodRuntimeReq;
import com.google.common.eventbus.Subscribe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackcatMethodRuntimeReqListener
implements BlackcatReqListener {
    private static final Logger log = LoggerFactory.getLogger(BlackcatMethodRuntimeReqListener.class);
    @Autowired
    MsgService msgService;
    @Autowired
    EventDao eventDao;
    @Autowired
    BlackcatConfigBean bean;
    static Pattern classMethod = Pattern.compile("(?<=\\.)(\\w+\\.\\w+)(?=\\()");

    @Subscribe
    public void deal(BlackcatMethodRuntimeReq req) {
        try {
            String hostname = req.getHostname();
            this.bean.getTimes().add((Object)(hostname + "-MethodRuntime-times"));
            this.tryAlert(req);
            this.eventDao.addMethodRuntime(req);
        }
        catch (Exception e) {
            log.error("deal BlackcatMethodRuntimeReq error", (Throwable)e);
        }
    }

    private void tryAlert(BlackcatMethodRuntimeReq req) {
        long methodMaxMillis = this.bean.getConfigThreshold().getMethodMaxMillis();
        if (this.throwableProcess(req)) {
            return;
        }
        this.maxMillisProess(req, methodMaxMillis);
    }

    private void maxMillisProess(BlackcatMethodRuntimeReq req, long methodMaxMillis) {
        boolean hasAlert;
        boolean bl = hasAlert = req.getRt().getCostNano() > methodMaxMillis * 1000000L;
        if (!hasAlert) {
            return;
        }
        StrBuilder alert = StrBuilder.str((char)'\n').p(req.getHostname());
        alert.p('\n').p(req.rt.getClassName());
        alert.p('\n').p(BlackcatMethodRuntimeReqListener.simpleMethodName(req.rt.getMethodDesc()));
        String cost = Blackcats.decimal((double)((double)req.rt.getCostNano() / 1000000.0)) + "ms";
        this.bean.getTimes().add((Object)(req.getHostname() + "-MethodRuntime-alerts"));
        this.msgService.sendMsg("\u65b9\u6cd5\u8017\u65f6" + cost, alert.toString());
    }

    private boolean throwableProcess(BlackcatMethodRuntimeReq req) {
        BlackcatMsg.BlackcatMethodRuntime rt = req.getRt();
        if (rt.getThrowableMessage() == null) {
            return false;
        }
        String traceLink = rt.getTraceId() + ":" + rt.getLinkId();
        this.msgService.sendMsg("\u5f02\u5e38\u6765\u4e86[" + traceLink + "]", rt.getThrowableMessage());
        return true;
    }

    private static String simpleMethodName(String source) {
        Matcher matcher = classMethod.matcher(source);
        matcher.find();
        return matcher.group();
    }
}

