/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.job;

import com.github.bingoohuang.blackcat.server.base.BlackcatJob;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.base.QuartzScheduler;
import com.github.bingoohuang.utils.net.HttpReq;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpCheckerJob
implements BlackcatJob {
    @Autowired
    MsgService msgService;
    Splitter splitter = Splitter.on((String)",").trimResults();

    @Override
    public void scheduleJob(QuartzScheduler scheduler) {
        JobDetail heartbeatJob = this.createHeartbeatJobDetail();
        Trigger heartbeatTrigger = this.createHeartbeatTrigger();
        scheduler.scheduleJob(heartbeatJob, heartbeatTrigger);
    }

    private JobDetail createHeartbeatJobDetail() {
        JobDetail job = JobBuilder.newJob(HttpCheckerQuartzJob.class).build();
        job.getJobDataMap().put("handler", (Object)this);
        return job;
    }

    private Trigger createHeartbeatTrigger() {
        return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(10).repeatForever()).startAt(DateBuilder.futureDate((int)70, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).build();
    }

    private void checkAllHttps() {
        File urlFile = new File("httpchecker.urls");
        if (urlFile.exists() && urlFile.isFile()) {
            List lines = Files.readLines((File)urlFile, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                this.checkHttp(line);
            }
        }
    }

    private void checkHttp(String line) {
        if (StringUtils.isEmpty((CharSequence)line)) {
            return;
        }
        List parts = this.splitter.splitToList((CharSequence)line);
        String name = (String)parts.get(0);
        String url = (String)parts.get(1);
        String result = new HttpReq(url).get();
        if (StringUtils.indexOf((CharSequence)result, (CharSequence)name) != -1) {
            return;
        }
        this.msgService.sendMsg("HTTP\u5de1\u68c0\u5f02\u5e38", name);
    }

    public static class HttpCheckerQuartzJob
    implements Job {
        public void execute(JobExecutionContext context) {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            HttpCheckerJob handler = (HttpCheckerJob)jobDataMap.get((Object)"handler");
            handler.checkAllHttps();
        }
    }
}

