/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.domain;

import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.server.base.BlackcatEventReq;
import org.joda.time.DateTime;

public class BlackcatMetricReq
implements BlackcatEventReq {
    private long ts;
    private String name;
    private String day;
    private long seq;
    private long val;

    public BlackcatMetricReq(BlackcatMsg.BlackcatReqHead head, BlackcatMsg.BlackcatMetric metric) {
        this.name = metric.getName();
        this.day = new DateTime(head.getTimestamp()).toString("yyyyMMdd");
        this.val = metric.getValue();
        this.ts = head.getTimestamp();
    }

    @Override
    public boolean isFromBlackcatAgent() {
        return false;
    }

    public long getTs() {
        return this.ts;
    }

    public String getName() {
        return this.name;
    }

    public String getDay() {
        return this.day;
    }

    public long getSeq() {
        return this.seq;
    }

    public long getVal() {
        return this.val;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public void setVal(long val) {
        this.val = val;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlackcatMetricReq)) {
            return false;
        }
        BlackcatMetricReq other = (BlackcatMetricReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$day = this.getDay();
        String other$day = other.getDay();
        if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
            return false;
        }
        if (this.getSeq() != other.getSeq()) {
            return false;
        }
        return this.getVal() == other.getVal();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlackcatMetricReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $day = this.getDay();
        result = result * 59 + ($day == null ? 43 : $day.hashCode());
        long $seq = this.getSeq();
        result = result * 59 + (int)($seq >>> 32 ^ $seq);
        long $val = this.getVal();
        result = result * 59 + (int)($val >>> 32 ^ $val);
        return result;
    }

    public String toString() {
        return "BlackcatMetricReq(ts=" + this.getTs() + ", name=" + this.getName() + ", day=" + this.getDay() + ", seq=" + this.getSeq() + ", val=" + this.getVal() + ")";
    }

    public BlackcatMetricReq() {
    }
}

