/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.domain;

import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.server.base.BlackcatEventReq;
import org.joda.time.DateTime;

public class BlackcatTraceReq
implements BlackcatEventReq {
    private String msg;
    private String msgType;
    private String hostname;
    private long ts;
    private String tsPretty;
    private String linkId;
    private String traceId;

    public BlackcatTraceReq(BlackcatMsg.BlackcatReqHead head, BlackcatMsg.BlackcatTrace trace) {
        this.traceId = trace.getTraceId();
        this.linkId = trace.getLinkId();
        this.ts = head.getTimestamp();
        this.tsPretty = new DateTime(this.ts).toString("yyyy-MM-dd HH:mm:ss.SSS");
        this.hostname = head.getHostname();
        this.msgType = trace.getMsgType();
        this.msg = trace.getMsg();
    }

    @Override
    public boolean isFromBlackcatAgent() {
        return false;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getTs() {
        return this.ts;
    }

    public String getTsPretty() {
        return this.tsPretty;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setTsPretty(String tsPretty) {
        this.tsPretty = tsPretty;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlackcatTraceReq)) {
            return false;
        }
        BlackcatTraceReq other = (BlackcatTraceReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        String this$tsPretty = this.getTsPretty();
        String other$tsPretty = other.getTsPretty();
        if (this$tsPretty == null ? other$tsPretty != null : !this$tsPretty.equals(other$tsPretty)) {
            return false;
        }
        String this$linkId = this.getLinkId();
        String other$linkId = other.getLinkId();
        if (this$linkId == null ? other$linkId != null : !this$linkId.equals(other$linkId)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlackcatTraceReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        String $tsPretty = this.getTsPretty();
        result = result * 59 + ($tsPretty == null ? 43 : $tsPretty.hashCode());
        String $linkId = this.getLinkId();
        result = result * 59 + ($linkId == null ? 43 : $linkId.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        return result;
    }

    public String toString() {
        return "BlackcatTraceReq(msg=" + this.getMsg() + ", msgType=" + this.getMsgType() + ", hostname=" + this.getHostname() + ", ts=" + this.getTs() + ", tsPretty=" + this.getTsPretty() + ", linkId=" + this.getLinkId() + ", traceId=" + this.getTraceId() + ")";
    }

    public BlackcatTraceReq() {
    }
}

