/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.job;

import com.github.bingoohuang.blackcat.server.base.BlackcatJob;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.base.QuartzScheduler;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import com.google.common.collect.Multiset;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMsgJob
implements BlackcatJob {
    @Autowired
    MsgService msgService;
    @Autowired
    BlackcatConfigBean configBean;
    public static final String MEMORY_TIMES = "-Memory-times";
    public static final String MEMORY_ALERTS = "-Memory-alerts";
    public static final String FILE_STORES_TIMES = "-FileStores-times";
    public static final String FILE_STORES_ALERTS = "-FileStores-alerts";
    public static final String LOAD_TIMES = "-Load-times";
    public static final String LOAD_ALERTS = "-Load-alerts";
    public static final String PROCESS_TIMES = "-Process-times";
    public static final String PROCESS_ALERTS = "-Process-alerts";
    public static final String METHODRUNTIME_TIMES = "-MethodRuntime-times";
    public static final String METHODRUNTIME_ALERTS = "-MethodRuntime-alerts";

    @Override
    public void scheduleJob(QuartzScheduler scheduler) {
        JobDetail job = this.createMsgJob();
        Trigger trigger = this.createMsgTrigger();
        scheduler.scheduleJob(job, trigger);
    }

    private JobDetail createMsgJob() {
        JobDetail job = JobBuilder.newJob(MsgQuartzJob.class).build();
        job.getJobDataMap().put("handler", (Object)this);
        return job;
    }

    private Trigger createMsgTrigger() {
        String cron = this.getCron();
        return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
    }

    protected abstract String getCron();

    private void triggerMsg() {
        String alertTimesMsg = this.compositeAlertTimesMsg();
        this.msgService.sendMsg("\u6700\u8fd1\u544a\u8b66\u6b21\u6570", alertTimesMsg);
    }

    private String compositeAlertTimesMsg() {
        int lastMemoryTimes = 0;
        int lastMemoryAlerts = 0;
        int lastFileStoresTimes = 0;
        int lastFileStoresAlerts = 0;
        int lastLoadTimes = 0;
        int lastLoadAlerts = 0;
        int lastProcessTimes = 0;
        int lastProcessAlerts = 0;
        Multiset<String> times = this.configBean.getTimes();
        for (String hostname : this.configBean.getConfigHostnames()) {
            lastMemoryTimes += times.count((Object)(hostname + MEMORY_TIMES));
            lastMemoryAlerts += times.count((Object)(hostname + MEMORY_ALERTS));
            lastFileStoresTimes += times.count((Object)(hostname + FILE_STORES_TIMES));
            lastFileStoresAlerts += times.count((Object)(hostname + FILE_STORES_ALERTS));
            lastLoadTimes += times.count((Object)(hostname + LOAD_TIMES));
            lastLoadAlerts += times.count((Object)(hostname + LOAD_ALERTS));
            lastProcessTimes += times.count((Object)(hostname + PROCESS_TIMES));
            lastProcessAlerts += times.count((Object)(hostname + PROCESS_ALERTS));
        }
        times.clear();
        return "\n" + "\u5185\u5b58" + lastMemoryAlerts + '/' + lastMemoryTimes + "\u6b21\n" + "\u78c1\u76d8" + lastFileStoresAlerts + '/' + lastFileStoresTimes + "\u6b21\n" + "\u8d1f\u8f7d" + lastLoadAlerts + '/' + lastLoadTimes + "\u6b21\n" + "\u8fdb\u7a0b" + lastProcessAlerts + '/' + lastProcessTimes + "\u6b21\n";
    }

    public static class MsgQuartzJob
    implements Job {
        public void execute(JobExecutionContext context) {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            AbstractMsgJob handler = (AbstractMsgJob)jobDataMap.get((Object)"handler");
            handler.triggerMsg();
        }
    }
}

