/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.base;

import java.util.Properties;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QuartzScheduler {
    private static final Logger log = LoggerFactory.getLogger(QuartzScheduler.class);
    Scheduler scheduler;

    public QuartzScheduler() {
        this.init();
    }

    private void init() {
        Properties p = new Properties();
        p.put("org.quartz.scheduler.skipUpdateCheck", "true");
        p.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        p.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        p.put("org.quartz.threadPool.threadCount", "1");
        StdSchedulerFactory schedFact = new StdSchedulerFactory(p);
        this.scheduler = schedFact.getScheduler();
        this.scheduler.start();
    }

    public void scheduleJob(JobDetail jobDetail, Trigger trigger) {
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            log.error("schedule job failed", (Throwable)e);
        }
    }

    public void deleteJob(JobKey key) {
        try {
            this.scheduler.deleteJob(key);
        }
        catch (SchedulerException e) {
            log.error("delete job failed", (Throwable)e);
        }
    }
}

