/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.domain;

import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.server.base.BlackcatEventReq;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;

public class BlackcatProcessReq
implements BlackcatEventReq {
    private final String hostname;
    private final long timestamp;
    private final List<Long> pids;
    private final List<String> args;
    private final List<String> names;
    private final List<Long> reses;
    private final List<Date> startTimes;

    public BlackcatProcessReq(BlackcatMsg.BlackcatReqHead head, BlackcatMsg.BlackcatProcess process) {
        this.hostname = head.getHostname();
        this.timestamp = head.getTimestamp();
        List procs = process.getProcList();
        this.pids = Lists.transform((List)procs, (Function)new Function<BlackcatMsg.BlackcatProcess.Proc, Long>(){

            public Long apply(BlackcatMsg.BlackcatProcess.Proc p) {
                return p.getPid();
            }
        });
        this.args = Lists.transform((List)procs, (Function)new Function<BlackcatMsg.BlackcatProcess.Proc, String>(){

            public String apply(BlackcatMsg.BlackcatProcess.Proc p) {
                return p.getArgs();
            }
        });
        this.names = Lists.transform((List)procs, (Function)new Function<BlackcatMsg.BlackcatProcess.Proc, String>(){

            public String apply(BlackcatMsg.BlackcatProcess.Proc p) {
                return p.getName();
            }
        });
        this.reses = Lists.transform((List)procs, (Function)new Function<BlackcatMsg.BlackcatProcess.Proc, Long>(){

            public Long apply(BlackcatMsg.BlackcatProcess.Proc p) {
                return p.getRes();
            }
        });
        this.startTimes = Lists.transform((List)procs, (Function)new Function<BlackcatMsg.BlackcatProcess.Proc, Date>(){

            public Date apply(BlackcatMsg.BlackcatProcess.Proc p) {
                return new Date(p.getStartTime());
            }
        });
    }

    @Override
    public boolean isFromBlackcatAgent() {
        return true;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Long> getPids() {
        return this.pids;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<Long> getReses() {
        return this.reses;
    }

    public List<Date> getStartTimes() {
        return this.startTimes;
    }
}

