/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.blackcat.server.eventlistener;

import com.github.bingoohuang.blackcat.sdk.protobuf.BlackcatMsg;
import com.github.bingoohuang.blackcat.sdk.utils.StrBuilder;
import com.github.bingoohuang.blackcat.server.base.BlackcatReqListener;
import com.github.bingoohuang.blackcat.server.base.MsgService;
import com.github.bingoohuang.blackcat.server.dao.EventDao;
import com.github.bingoohuang.blackcat.server.domain.BlackcatConfigBean;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventLast;
import com.github.bingoohuang.blackcat.server.domain.BlackcatEventType;
import com.github.bingoohuang.blackcat.server.domain.BlackcatLoadReq;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlackcatLoadReqListener
implements BlackcatReqListener {
    @Autowired
    MsgService msgService;
    @Autowired
    EventDao eventDao;
    @Autowired
    BlackcatConfigBean bean;

    @Subscribe
    public void deal(BlackcatLoadReq req) {
        String hostname = req.getHostname();
        this.bean.getTimes().add((Object)(hostname + "-Load-times"));
        this.bean.getBeats().put(hostname, System.currentTimeMillis());
        this.tryAlert(req);
        this.eventDao.updateEventLast(new BlackcatEventLast(hostname, BlackcatEventType.Load.toString(), req.getTimestamp()));
        this.eventDao.addLoadEvent(req);
    }

    private void tryAlert(BlackcatLoadReq req) {
        BlackcatMsg.BlackcatLoad load = req.getLoad();
        int confRatio = this.bean.getConfigThreshold().getLoadOverRatio();
        int ratio = (int)(load.getFiveMinsAvg() * 100.0f / (float)load.getCpuNum());
        if (ratio - 100 <= confRatio) {
            return;
        }
        List topProcessList = load.getTopProcessList();
        StrBuilder alert = StrBuilder.str((char)'\n').p(req.getHostname()).p("\u76845\u5206\u949f\u8d1f\u8f7d").p(load.getFiveMinsAvg()).p("\u8d85\u8fc7\u544a\u8b66\u9608\u503c").p(confRatio).p('%').p('\n').p(topProcessList.subList(0, Math.min(topProcessList.size(), 3)));
        this.bean.getTimes().add((Object)(req.getHostname() + "-Load-alerts"));
        this.msgService.sendMsg("\u8d1f\u8f7d\u544a\u8b66", alert.toString());
    }
}

